/*
 * (C) Copyright 2006-2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.runtime.remoting.net.impl;

import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.remoting.net.NetworkNode;
import org.nuxeo.runtime.remoting.net.NetworkNodeFactory;
import org.nuxeo.runtime.remoting.net.NodeInfo;

/**
 * @author  <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 *
 */
public class NetworkNodeFactoryImpl implements NetworkNodeFactory {

    public NetworkNode createNode(RemotingService service, NodeInfo info) throws Exception {
        return new NetworkNodeImpl(service, info);
    }

}
