/*
 * (C) Copyright 2006-2007 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.runtime.remoting.net.multicast;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkNotification;
import org.jboss.remoting.network.NetworkRegistry;
import org.nuxeo.runtime.remoting.RemotingService;

/**
 * NOT USED - should be refactored to implement a NetworkNode using
 * jboss-remoting multicast detection.
 *
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 *
 */
public class ServerDetection implements NotificationListener {

    private static final Log log = LogFactory.getLog(ServerDetection.class);

    private MulticastDetector detector;

    private NetworkRegistry registry;

    private MBeanServer mbeanServer;

    private final RemotingService remoting;

    public ServerDetection(RemotingService server) {
        mbeanServer = createMBeanServer();
        remoting = server;
    }

    protected MBeanServer createMBeanServer() {
        mbeanServer = MBeanServerFactory.createMBeanServer();
        return mbeanServer;
    }

    protected MulticastDetector createMulticastDetector(MBeanServer server)
            throws Exception {
        // multicast detector will detect new network registries that come online
        MulticastDetector detector = new MulticastDetector();
// domain refer to the entire server so it doesn't help me to filter nxruntime server locators
//        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance()
//                .newDocumentBuilder();
//        Document doc = docBuilder.newDocument();
//        Element domains = doc.createElement("domains");
//        Element domain = doc.createElement("domain");
//        domain.setTextContent("nxruntime");
//        domains.appendChild(domain);
//        doc.appendChild(domains);
//        detector.setConfiguration(domains);
        server.registerMBean(detector, new ObjectName(
                "remoting:type=MulticastDetector"));
        return detector;
    }

    protected NetworkRegistry createNetworkRegistry(MBeanServer server)
            throws Exception {
        // the registry will house all remoting servers discovered
        NetworkRegistry registry = NetworkRegistry.getInstance();
        server.registerMBean(registry, new ObjectName(
                "remoting:type=NetworkRegistry"));

        // register class as listener, so know when new server found
        registry.addNotificationListener(this, null, null);
        log.info("NetworkRegistry has been created");

        return registry;
    }

    public void start() throws Exception {
        registry = createNetworkRegistry(mbeanServer);
        detector = createMulticastDetector(mbeanServer);
        detector.start();
        log.info("MulticastDetector has been started");
    }

    public void stop() throws Exception {
        detector.stop();
        detector = null;
        registry = null;
        log.info("MulticastDetector has been stopped");
    }

    public NetworkRegistry getNetworkRegistry() {
        return registry;
    }

    public void handleNotification(Notification notification, Object handback) {
        // check to see if network notification
        if (notification instanceof NetworkNotification) {
            NetworkNotification networkNotification = (NetworkNotification) notification;
            String type = notification.getType();
            log.debug("Got a network-registry notification: " + type);

            if (NetworkNotification.SERVER_ADDED.equals(type)) {
//                // notification is for new servers being added
//                log.debug("New server(s) have been detected");
//                InvokerLocator[] locators = networkNotification.getLocator();
//                System.out.println("$$$$$$$$$$$$$$$$$$ " + Arrays.toString(locators));
//                for (InvokerLocator locator : locators) {
//                    if ("nxruntime".equals(locator.getPath())
//                            && !locator.equals(remoting.getLocalIdentity().getLocator())) {
//                        // register nx-runtime server if not already registered
//                        try {
//                            ServerIdentity identity = new ServerIdentity(locator);
//                            log.info("Detected remote server: " + identity);
//                            remoting.getServerRegistry().getOrRegister(identity);
//                        } catch (Exception e) {
//                            log.error("Failed to register remote server", e);
//                        }
//                    }
//                }
            } else if (NetworkNotification.SERVER_REMOVED.equals(type)) {
//                // notificationis for servers that have gone down
//                log.debug("Existing server(s) have been shutdown");
//                InvokerLocator[] locators = networkNotification.getLocator();
//                System.out.println("$$$$$$$$$$$$$$$$$$ " + Arrays.toString(locators));
//                for (InvokerLocator locator : locators) {
//                    if ("nxruntime".equals(locator.getPath())
//                            && !locator.equals(remoting.getLocalIdentity().getLocator())) {
//                        // unregister nx-runtime server
//                        log.info("Removing remote server: " + locator.getLocatorURI());
//                        remoting.getServerRegistry().remove(locator.getLocatorURI());
//                    }
//                }
            }
        }

    }

}
