/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.streaming;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.nuxeo.runtime.services.streaming.AbstractStreamSource;

public class ZipEntrySource
extends AbstractStreamSource {
    protected final String file;
    protected final String entry;

    public ZipEntrySource(String file, String entry) {
        this.file = file;
        this.entry = entry;
    }

    public ZipEntrySource(File file, String entry) {
        this.file = file.getAbsolutePath();
        this.entry = entry;
    }

    public InputStream getStream() throws IOException {
        ZipFile zf = new ZipFile(this.file);
        ZipEntry zentry = zf.getEntry(this.entry);
        if (zentry == null) {
            return null;
        }
        return new ZipEntryInputStream(zf, zf.getInputStream(zentry));
    }

    public boolean canReopen() {
        return true;
    }

    public long getLength() throws IOException {
        return -1L;
    }

    class ZipEntryInputStream
    extends InputStream {
        final InputStream in;
        final ZipFile zip;

        public ZipEntryInputStream(ZipFile zip, InputStream in) {
            this.in = in;
            this.zip = zip;
        }

        public int available() throws IOException {
            return this.in.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.in.close();
            }
            finally {
                this.zip.close();
            }
        }

        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }

        public synchronized void reset() throws IOException {
            this.in.reset();
        }

        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }
    }
}

