/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceGroup;
import org.nuxeo.runtime.api.ServiceHost;
import org.nuxeo.runtime.api.ServiceLocator;
import org.nuxeo.runtime.api.ServiceLocatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceManager
implements org.nuxeo.runtime.ServiceManager {
    private static final Log log = LogFactory.getLog(ServiceManager.class);
    private static final ServiceManager instance = new ServiceManager();
    private final Map<String, ServiceDescriptor> services = new HashMap<String, ServiceDescriptor>();
    private final List<ServiceHost> servers = new Vector<ServiceHost>();
    private final Map<String, ServiceGroup> groups = new HashMap<String, ServiceGroup>();

    private ServiceManager() {
    }

    public static ServiceManager getInstance() {
        return instance;
    }

    public ServiceDescriptor[] getServiceDescriptors() {
        return this.services.values().toArray(new ServiceDescriptor[this.services.size()]);
    }

    public ServiceDescriptor getServiceDescriptor(Class<?> serviceClass) {
        return this.getServiceDescriptor(serviceClass.getName());
    }

    public ServiceDescriptor getServiceDescriptor(String serviceClass) {
        return this.services.get(serviceClass);
    }

    public ServiceDescriptor getServiceDescriptor(Class<?> serviceClass, String name) {
        return this.getServiceDescriptor(serviceClass.getName(), name);
    }

    public ServiceDescriptor getServiceDescriptor(String serviceClass, String name) {
        return this.services.get(serviceClass + '#' + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceDescriptor sd) {
        String key = sd.getInstanceName();
        Map<String, ServiceDescriptor> map = this.services;
        synchronized (map) {
            if (this.services.containsKey(key)) {
                String msg = "Duplicate service registration: " + key;
                log.error((Object)msg);
                Framework.getRuntime().getWarnings().add(msg);
                return;
            }
            this.services.put(key, sd);
            sd.getGroup().addService(sd);
            log.info((Object)("Registered service: " + key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(ServiceDescriptor sd) {
        String key = sd.getInstanceName();
        Map<String, ServiceDescriptor> map = this.services;
        synchronized (map) {
            sd = this.services.remove(key);
            if (sd == null) {
                log.warn((Object)String.format("Cannot unregister service '%s': either already unregistered or not registered at all", key));
            } else {
                sd.getGroup().removeService(sd);
                log.info((Object)("Unregistered service: " + key));
            }
        }
    }

    @Override
    public <T> T getService(Class<T> serviceClass) throws Exception {
        ServiceDescriptor sd = this.services.get(serviceClass.getName());
        if (sd != null) {
            try {
                Object svc = sd.getGroup().getServer().lookup(sd);
                if (svc != null) {
                    return (T)svc;
                }
            }
            catch (NameNotFoundException e) {
                log.warn((Object)("Existing binding but unreachable service for " + serviceClass.getName() + " ! Fallback on local service..."));
                log.debug((Object)(e.getMessage() + " Check binding declaration: " + sd.toString()));
            }
        }
        return Framework.getLocalService(serviceClass);
    }

    @Override
    public <T> T getService(Class<T> serviceClass, String name) throws Exception {
        ServiceDescriptor sd = this.services.get(serviceClass.getName() + '#' + name);
        log.trace((Object)("Known services" + this.services.keySet().toString()));
        if (sd == null) {
            return Framework.getLocalService(serviceClass);
        }
        return (T)sd.getGroup().getServer().lookup(sd);
    }

    public Object getService(String serviceUri) throws Exception {
        URI uri = new URI(serviceUri);
        ServiceLocatorFactory factory = ServiceLocatorFactory.getFactory(uri.getScheme());
        if (factory != null) {
            ServiceLocator locator = factory.createLocator(uri);
            return locator.lookup(uri.getPath().substring(1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceGroup getOrCreateGroup(String name) {
        if (name == null || name.length() == 0) {
            name = "*";
        }
        Map<String, ServiceGroup> map = this.groups;
        synchronized (map) {
            ServiceGroup group = this.groups.get(name);
            if (group == null) {
                group = new ServiceGroup(name);
                this.groups.put(name, group);
            }
            return group;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceGroup getGroup(String name) {
        Map<String, ServiceGroup> map = this.groups;
        synchronized (map) {
            return this.groups.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String name) {
        Map<String, ServiceGroup> map = this.groups;
        synchronized (map) {
            this.groups.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(String name) {
        if (name == null || name.length() == 0) {
            name = "*";
        }
        ServiceGroup group = new ServiceGroup(name);
        Map<String, ServiceGroup> map = this.groups;
        synchronized (map) {
            this.groups.put(name, group);
        }
    }

    public ServiceGroup getRootGroup() {
        return this.getOrCreateGroup("*");
    }

    public void registerServer(ServiceHost server) {
        this.servers.add(server);
    }

    public void unregisterServer(ServiceHost server) {
        this.servers.remove(server);
        server.dispose();
    }

    public void removeServers() {
        for (ServiceHost server : this.servers) {
            server.dispose();
        }
        this.servers.clear();
    }

    public void removeServices() {
        this.services.clear();
    }

    public void removeGroups() {
        this.groups.clear();
    }

    public void reset() {
        this.removeServices();
        this.removeGroups();
        this.removeServers();
    }

    public ServiceHost[] getServers() {
        return this.servers.toArray(new ServiceHost[this.servers.size()]);
    }
}

