/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.J2EEContainerDescriptor;

public class DataSourceHelper {
    private static final Log log = LogFactory.getLog(DataSourceHelper.class);
    private static final String JBOSS_PREFIX = "java:";
    private static final String DEFAULT_PREFIX = "java:";
    private static final String DS_PREFIX_NAME = "org.nuxeo.runtime.datasource.prefix";
    protected static String prefix;

    protected static void dump(String msg) {
        System.out.println(msg);
        log.warn((Object)msg);
    }

    public static void autodetectPrefix() {
        J2EEContainerDescriptor selectedContainer = J2EEContainerDescriptor.getSelected();
        prefix = selectedContainer == null ? null : selectedContainer.datasourcePrefix;
    }

    public static void setDataSourceJNDIPrefix(String prefix) {
        DataSourceHelper.prefix = prefix;
    }

    public static String getDataSourceJNDIPrefix() {
        if (prefix == null) {
            if (Framework.isInitialized()) {
                String configuredPrefix = Framework.getProperty(DS_PREFIX_NAME);
                if (configuredPrefix != null) {
                    prefix = configuredPrefix;
                }
                if (prefix == null) {
                    DataSourceHelper.autodetectPrefix();
                }
                if (prefix == null) {
                    return "java:";
                }
            } else {
                return "java:";
            }
        }
        return prefix;
    }

    public static String getDataSourceJNDIName(String partialName) {
        if (partialName == null) {
            return null;
        }
        String targetPrefix = DataSourceHelper.getDataSourceJNDIPrefix();
        if (partialName.startsWith(targetPrefix)) {
            return partialName;
        }
        int idx = partialName.indexOf("/");
        if (idx > 0) {
            partialName = partialName.substring(idx + 1);
        }
        return targetPrefix + "/" + partialName;
    }

    public static DataSource getDataSource(String partialName) throws NamingException {
        String jndiName = DataSourceHelper.getDataSourceJNDIName(partialName);
        InitialContext context = new InitialContext();
        DataSource dataSource = (DataSource)context.lookup(jndiName);
        return dataSource;
    }
}

