/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum J2EEContainerDescriptor {
    JBOSS("java:", "JTA", false),
    TOMCAT("java:comp/env/jdbc", "RESOURCE_LOCAL", true),
    JETTY("jdbc", "RESOURCE_LOCAL", true),
    GF3("jdbc", "RESOURCE_LOCAL", true);

    public final String datasourcePrefix;
    public final String txFactory;
    public final boolean preferLocalBindings;
    public static final Log log;
    private static J2EEContainerDescriptor selected;

    private J2EEContainerDescriptor(String datasourcePrefix, String hibernateTransactionStrategy, boolean preferLocalBindings) {
        this.datasourcePrefix = datasourcePrefix;
        this.txFactory = hibernateTransactionStrategy;
        this.preferLocalBindings = preferLocalBindings;
    }

    protected static J2EEContainerDescriptor autodetect() {
        Environment env = Environment.getDefault();
        String hostName = env.getHostApplicationName();
        if (hostName == null) {
            return null;
        }
        if ("JBoss".equals(hostName)) {
            log.info((Object)"Detected JBoss host");
            return JBOSS;
        }
        if ("Tomcat".equals(hostName)) {
            log.info((Object)"Detected Tomcat host");
            return TOMCAT;
        }
        if ("NXServer".equals(hostName)) {
            try {
                Class.forName("com.sun.enterprise.glassfish.bootstrap.AbstractMain");
                log.info((Object)"Detected GlassFish host");
                return GF3;
            }
            catch (Exception e) {
                log.debug((Object)"Autodetect : not a glassfish host");
                try {
                    Class.forName("org.mortbay.jetty.webapp.WebAppContext");
                    log.info((Object)"Detected Jetty host");
                    return JETTY;
                }
                catch (Exception e2) {
                    log.debug((Object)"Autodetect : not a jetty host");
                    return null;
                }
            }
        }
        return null;
    }

    public static void setSelected(J2EEContainerDescriptor selected) {
        J2EEContainerDescriptor.selected = selected;
    }

    public static J2EEContainerDescriptor getSelected() {
        if (selected != null) {
            return selected;
        }
        selected = J2EEContainerDescriptor.autodetect();
        return selected;
    }

    static {
        log = LogFactory.getLog(J2EEContainerDescriptor.class);
    }
}

