/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.nuxeo.runtime.api.login.DefaultCallback;

public class DefaultCallbackHandler
implements CallbackHandler {
    private final String username;
    private char[] password;
    private final Object credential;

    public DefaultCallbackHandler(String username, char[] password) {
        this.username = username;
        this.password = password;
        this.credential = password;
    }

    public DefaultCallbackHandler(String username, Object credential) {
        this.username = username;
        this.credential = credential;
        if (credential instanceof char[]) {
            this.password = (char[])credential;
        } else if (credential instanceof CharSequence) {
            this.password = credential.toString().toCharArray();
        }
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback c : callbacks) {
            if (c instanceof NameCallback) {
                NameCallback nc = (NameCallback)c;
                nc.setName(this.username);
                continue;
            }
            if (c instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)c;
                if (this.password == null && this.credential != null) {
                    String tmp = this.credential.toString();
                    this.password = tmp.toCharArray();
                }
                pc.setPassword(this.password);
                continue;
            }
            if (c instanceof DefaultCallback) {
                DefaultCallback oc = (DefaultCallback)c;
                oc.setCredential(this.credential);
                continue;
            }
            throw new UnsupportedCallbackException(c, "Unrecognized Callback");
        }
    }
}

