/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.config;

import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.remoting.InvokerLocator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceHost;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.api.login.LoginService;
import org.nuxeo.runtime.api.login.SecurityDomain;
import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.remoting.Server;
import org.nuxeo.runtime.remoting.transporter.TransporterClient;
import org.nuxeo.runtime.services.streaming.StreamingService;

public class Configuration {
    public static final int IGNORE = 0;
    public static final int APPEND = 1;
    public static final int REPLACE = 2;
    public static final int RESET = 3;
    private final ServiceManager serviceMgr = Framework.getLocalService(ServiceManager.class);
    private final LoginService loginMgr = Framework.getLocalService(LoginService.class);
    private int updateBindingsOption = 3;
    private int updateServersOption = 3;
    private int updateLoginOption = 3;
    private int updateStreamingOption = 3;
    private Properties properties;

    public String getName() {
        if (this.properties == null) {
            throw new IllegalStateException("Configuration was not fetched from the server");
        }
        return this.properties.getProperty("org.nuxeo.ecm.instance.name");
    }

    public String getDescription() {
        if (this.properties == null) {
            throw new IllegalStateException("Configuration was not fetched from the server");
        }
        return this.properties.getProperty("org.nuxeo.ecm.instance.description");
    }

    public Properties getProperties() {
        if (this.properties == null) {
            throw new IllegalStateException("Configuration was not fetched from the server");
        }
        return this.properties;
    }

    public void setBindingsUpdateOption(int updateBindingsOption) {
        this.updateBindingsOption = updateBindingsOption;
    }

    public void setLoginUpdateOption(int updateLoginOption) {
        this.updateLoginOption = updateLoginOption;
    }

    public void setServersUpdateOption(int updateServersOption) {
        this.updateServersOption = updateServersOption;
    }

    public void setUpdateStreamingOption(int updateStreamingOption) {
        this.updateStreamingOption = updateStreamingOption;
    }

    public int getUpdateBindingsOption() {
        return this.updateBindingsOption;
    }

    public int getUpdateLoginOption() {
        return this.updateLoginOption;
    }

    public int getUpdateServersOption() {
        return this.updateServersOption;
    }

    public int getUpdateStreamingOption() {
        return this.updateStreamingOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String uri) throws Exception {
        InvokerLocator locator = new InvokerLocator(uri);
        Server server = (Server)TransporterClient.createTransporterClient(locator, Server.class);
        try {
            this.load(server, locator.getHost(), uri);
        }
        finally {
            TransporterClient.destroyTransporterClient(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String host, int port) throws Exception {
        String serverLocator = RemotingService.getServerURI(host, port);
        Server server = RemotingService.connect(serverLocator);
        try {
            this.load(server, host, serverLocator);
        }
        finally {
            TransporterClient.destroyTransporterClient(server);
        }
    }

    void load(Server server, String host, String serverLocator) throws Exception {
        if (this.updateBindingsOption == 3) {
            this.serviceMgr.removeServices();
            this.serviceMgr.removeGroups();
        }
        if (this.updateServersOption == 3) {
            this.serviceMgr.removeServers();
        }
        if (this.updateLoginOption == 3) {
            this.loginMgr.removeSecurityDomains();
        }
        this.properties = server.getProperties();
        if (this.updateStreamingOption != 0) {
            Configuration.loadStreamingConfig(serverLocator);
        }
        if (this.updateBindingsOption != 0) {
            this.loadServiceBindings(server);
        }
        if (this.updateServersOption != 0) {
            this.loadServiceHosts(server, host);
        }
        if (this.updateLoginOption != 0) {
            this.loadLoginConfig(server);
        }
    }

    private static void loadStreamingConfig(String serverLocator) throws Exception {
        String oldLocator;
        StreamingService streamingService = (StreamingService)Framework.getRuntime().getComponent(StreamingService.NAME);
        if (!streamingService.isServer() && !serverLocator.equals(oldLocator = streamingService.getServerLocator())) {
            streamingService.stopManager();
            streamingService.setServerLocator(serverLocator);
            streamingService.setServer(false);
            streamingService.startManager();
        }
    }

    private void loadLoginConfig(Server server) throws Exception {
        Map<String, Object[][]> domains = server.getSecurityDomains();
        for (Map.Entry<String, Object[][]> entry : domains.entrySet()) {
            String name = entry.getKey();
            SecurityDomain domain = new SecurityDomain(name);
            Object[][] values = entry.getValue();
            AppConfigurationEntry[] appEntries = new AppConfigurationEntry[values.length];
            for (int i = 0; i < values.length; ++i) {
                String loginModuleName = values[i][0].toString();
                AppConfigurationEntry.LoginModuleControlFlag flag = SecurityDomain.controlFlagFromString(values[i][1].toString());
                Map options = (Map)values[i][2];
                appEntries[i] = new AppConfigurationEntry(loginModuleName, flag, options);
            }
            domain.setAppConfigurationEntries(appEntries);
            if (this.updateLoginOption == 2) {
                this.loginMgr.addSecurityDomain(domain);
                continue;
            }
            if (null != this.loginMgr.getSecurityDomain(name)) continue;
            this.loginMgr.addSecurityDomain(domain);
        }
    }

    private void loadServiceBindings(Server server) {
        String[] bindings = server.getServiceBindings();
        for (int i = 0; i < bindings.length; i += 4) {
            String group = bindings[i];
            String className = bindings[i + 1];
            String name = bindings[i + 2];
            String locator = bindings[i + 3];
            ServiceDescriptor sd = new ServiceDescriptor(className, group, name);
            sd.setLocator(locator);
            this.serviceMgr.registerService(sd);
        }
    }

    private void loadServiceHosts(Server server, String host) throws Exception {
        for (Properties props : server.getServiceHosts()) {
            String addr;
            String className = (String)props.remove("@class");
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(className);
            ServiceHost serviceHost = new ServiceHost(klass);
            String[] groups = (String[])props.remove("@groups");
            if (groups != null) {
                serviceHost.setGroups(groups);
            }
            if ((addr = (String)props.remove("@host")) != null) {
                Integer port;
                if (addr.equals("localhost") || addr.equals("127.0.0.1") || addr.equals("0.0.0.0")) {
                    addr = host;
                }
                serviceHost.setAddress(host, (port = (Integer)props.remove("@port")) != null ? port : 0);
            }
            serviceHost.setProperties(props);
            this.serviceMgr.registerServer(serviceHost);
        }
    }
}

