/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.service.AdaptableService;
import org.nuxeo.runtime.service.AdapterManager;
import org.nuxeo.runtime.service.NoSuchAdapterException;
import org.nuxeo.runtime.service.proxy.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptableServiceImpl
implements AdaptableService {
    protected final AdapterManager adapterManager = AdapterManager.getInstance();
    protected final Map<Class<?>, Object> adapters = new ConcurrentHashMap();

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object obj = this.adapters.get(adapter);
        if (obj == null && (obj = this.adapterManager.getAdapter(this, adapter)) != null) {
            this.adapters.put(adapter, obj);
        }
        return (T)obj;
    }

    @Override
    public boolean hasAdapter(Class<?> adapter) {
        return this.getAdapter(adapter) != null;
    }

    @Override
    public Object invokeAdapter(MethodInvocation invocation, Object[] args) throws NoSuchAdapterException, InvocationTargetException, IllegalAccessException {
        Method m = invocation.getMethod();
        Class<?> adapterClass = m.getDeclaringClass();
        Object adapterInstance = this.getAdapter(adapterClass);
        if (adapterInstance == null) {
            throw new NoSuchAdapterException(adapterClass.getName());
        }
        return m.invoke(adapterInstance, args);
    }
}

