/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.streaming;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.runtime.remoting.transporter.TransporterClient;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.InputStreamSource;
import org.nuxeo.runtime.services.streaming.RemoteInputStream;
import org.nuxeo.runtime.services.streaming.StreamManager;
import org.nuxeo.runtime.services.streaming.StreamSource;
import org.nuxeo.runtime.services.streaming.StreamingServer;

public class StreamManagerClient
implements StreamManager {
    protected final StreamingServer server;
    protected int minBufSize;
    protected int maxBufSize;

    public StreamManagerClient(String serverLocator) throws Exception {
        this(serverLocator, 8192, 0x800000);
    }

    public StreamManagerClient(String serverLocator, int minBufSize, int maxBufSize) throws Exception {
        this.server = (StreamingServer)TransporterClient.createTransporterClient(serverLocator, StreamingServer.class);
        this.minBufSize = minBufSize;
        this.maxBufSize = maxBufSize;
    }

    public void start() throws Exception {
    }

    public void stop() {
        TransporterClient.destroyTransporterClient(this.server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String addStream(StreamSource src) throws IOException {
        InputStream in = src.getStream();
        String uri = this.server.createUploadSession();
        byte[] bytes = new byte[this.getBufferSize(in.available())];
        try {
            int ret;
            while ((ret = in.read(bytes)) != -1) {
                byte[] bytesToUpload;
                if (ret < bytes.length) {
                    bytesToUpload = new byte[ret];
                    System.arraycopy(bytes, 0, bytesToUpload, 0, ret);
                } else {
                    bytesToUpload = bytes;
                }
                this.server.uploadBytes(uri, bytesToUpload);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.server.closeUploadSession(uri);
        }
        return uri;
    }

    protected int getBufferSize(int available) {
        if (available > 0) {
            if (available <= this.minBufSize) {
                return this.minBufSize;
            }
            if (available > this.maxBufSize) {
                return this.maxBufSize;
            }
            return available;
        }
        return 65536;
    }

    public synchronized StreamSource getStream(String uri) throws IOException {
        RemoteInputStream in = new RemoteInputStream(this, uri);
        return new InputStreamSource(in);
    }

    public synchronized boolean hasStream(String uri) {
        return this.server.hasStream(uri);
    }

    public synchronized void removeStream(String uri) {
        this.server.removeStream(uri);
    }

    public void setMaxBufferSize(int maxBufSize) {
        this.maxBufSize = maxBufSize;
    }

    public void setMinBufferSize(int minBufSize) {
        this.minBufSize = minBufSize;
    }

    public StreamingServer getServer() {
        return this.server;
    }

    public static void main(String[] args) {
        try {
            StreamManagerClient client = new StreamManagerClient("socket://localhost:3233");
            client.start();
            System.out.println("stream client started");
            StreamSource src = new FileSource(new File("/home/bstefanescu/test"));
            double s = System.currentTimeMillis();
            String uri = client.addStream(src);
            double e = System.currentTimeMillis();
            System.out.println(">>> upload took " + (e - s) / 1000.0 + " sec.");
            src = client.getStream(uri);
            client.removeStream(uri);
            client.stop();
            System.out.println("Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

