/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Serializable,
Comparable<Version> {
    public static final Version ZERO;
    public static final Version MIN;
    public static final Version MAX;
    private static final long serialVersionUID = 4287621413157054503L;
    private final int major;
    private final int minor;
    private final int update;

    public Version(int major, int minor, int update) {
        this.major = major;
        this.minor = minor;
        this.update = update;
    }

    public static Version parseString(String version) {
        int p = version.indexOf(46, 0);
        if (p > -1) {
            int major = Integer.parseInt(version.substring(0, p));
            int q = version.indexOf(46, p + 1);
            if (q > -1) {
                int minor = Integer.parseInt(version.substring(p + 1, q));
                int update = Integer.parseInt(version.substring(q + 1));
                return new Version(major, minor, update);
            }
            return new Version(major, Integer.parseInt(version.substring(p + 1)), 0);
        }
        return new Version(Integer.parseInt(version), 0, 0);
    }

    public boolean isGreaterThan(Version version) {
        if (this.major > version.major) {
            return true;
        }
        if (this.major < version.major) {
            return false;
        }
        if (this.minor > version.minor) {
            return true;
        }
        if (this.minor < version.minor) {
            return false;
        }
        return this.update > version.update;
    }

    public boolean isGreaterOrEqualThan(Version version) {
        if (this.major > version.major) {
            return true;
        }
        if (this.major < version.major) {
            return false;
        }
        if (this.minor > version.minor) {
            return true;
        }
        if (this.minor < version.minor) {
            return false;
        }
        return this.update >= version.update;
    }

    public boolean isEqualTo(Version version) {
        return this.major == version.major && this.minor == version.minor && this.update == version.update;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getUpdateVersion() {
        return this.update;
    }

    public String toString() {
        return new StringBuffer().append(this.major).append('.').append(this.minor).append('.').append(this.update).toString();
    }

    public int hashCode() {
        return this.major ^ this.minor << 8 ^ this.update << 16;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Version) {
            return this.isEqualTo((Version)object);
        }
        return false;
    }

    @Override
    public int compareTo(Version v) {
        if (v == null) {
            return -1;
        }
        if (this.isEqualTo(v)) {
            return 0;
        }
        return this.isGreaterThan(v) ? 1 : 0;
    }

    static {
        MIN = ZERO = new Version(0, 0, 0);
        MAX = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

