/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deploy;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.deploy.FileChangeListener;

public class FileChangeNotifier {
    private static final Log log = LogFactory.getLog(FileChangeNotifier.class);
    private final ListenerList listeners = new ListenerList();
    private final Timer timer = new Timer("FileChangeNotifier");
    private final Map<String, FileEntry> files = new Hashtable<String, FileEntry>();

    public void start(int startAfter, int interval) {
        this.timer.scheduleAtFixedRate((TimerTask)new WatchTask(), startAfter, (long)interval);
    }

    public void start() {
        this.start(10000, 2000);
    }

    public void stop() {
        this.timer.cancel();
        this.timer.purge();
    }

    public String watch(File file) throws IOException {
        FileEntry entry = new FileEntry(file);
        this.files.put(entry.id, entry);
        return entry.id;
    }

    public String watch(String id, File file) throws IOException {
        this.files.put(id, new FileEntry(id, file));
        return id;
    }

    public void unwatch(File file) throws IOException {
        this.files.remove((FileChangeNotifier)this.new FileEntry((File)file).id);
    }

    public void unwatch(String id, File file) throws IOException {
        this.files.remove((FileChangeNotifier)this.new FileEntry((String)id, (File)file).id);
    }

    public void addListener(FileChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(FileChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireNotification(FileEntry entry) {
        long tm = System.currentTimeMillis();
        for (Object listener : this.listeners.getListeners()) {
            try {
                ((FileChangeListener)listener).fileChanged(entry, tm);
            }
            catch (Throwable t) {
                log.error((Object)("Error while to notifying file change for: " + entry.file), t);
            }
        }
    }

    public class FileEntry {
        public final String id;
        public final File file;
        public long lastModified;

        FileEntry(String id, File file) throws IOException {
            this.file = file.getCanonicalFile();
            this.lastModified = file.lastModified();
            this.id = id == null ? file.getAbsolutePath() : id;
        }

        FileEntry(File file) throws IOException {
            this(null, file);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() == FileEntry.class) {
                return this.id.equals(((FileEntry)obj).id);
            }
            return false;
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }

        public String toString() {
            return this.id;
        }
    }

    class WatchTask
    extends TimerTask {
        WatchTask() {
        }

        public void run() {
            try {
                FileEntry[] entries;
                for (FileEntry entry : entries = FileChangeNotifier.this.files.values().toArray(new FileEntry[FileChangeNotifier.this.files.size()])) {
                    long lastModified = entry.file.lastModified();
                    if (entry.lastModified >= lastModified) continue;
                    FileChangeNotifier.this.fireNotification(entry);
                    entry.lastModified = lastModified;
                }
            }
            catch (Throwable t) {
                log.error((Object)"Error while to notifying file change", t);
            }
        }
    }
}

