/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.ComponentEvent;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.ConfigurationDescriptor;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.ExtensionPoint;
import org.nuxeo.runtime.model.Property;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentInstanceImpl;
import org.nuxeo.runtime.model.impl.ComponentManagerImpl;
import org.nuxeo.runtime.model.impl.ExtensionImpl;
import org.nuxeo.runtime.model.impl.ExtensionPointImpl;
import org.nuxeo.runtime.model.impl.ServiceDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XObject(value="component")
public class RegistrationInfoImpl
implements RegistrationInfo {
    private static final long serialVersionUID = -4135715215018199522L;
    private static final Log log = LogFactory.getLog(RegistrationInfoImpl.class);
    transient ComponentManagerImpl manager;
    @XNode(value="@service")
    ServiceDescriptor serviceDescriptor;
    @XNode(value="@name")
    ComponentName name;
    @XNode(value="configuration")
    ConfigurationDescriptor config;
    int state = 0;
    @XNodeList(value="require", type=HashSet.class, componentType=ComponentName.class)
    Set<ComponentName> requires;
    Set<ComponentName> waitsFor;
    Set<RegistrationInfoImpl> dependsOnMe;
    @XNode(value="implementation@class")
    String implementation;
    @XNodeList(value="extension-point", type=ExtensionPointImpl[].class, componentType=ExtensionPointImpl.class)
    ExtensionPointImpl[] extensionPoints;
    @XNodeList(value="extension", type=ExtensionImpl[].class, componentType=ExtensionImpl.class)
    ExtensionImpl[] extensions;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=Property.class)
    Map<String, Property> properties;
    @XNode(value="@version")
    Version version = Version.ZERO;
    @XContent(value="documentation")
    String documentation;
    URL xmlFileUrl;
    boolean isPersistent;
    transient RuntimeContext context;
    transient ComponentInstance component;

    public RegistrationInfoImpl() {
    }

    public RegistrationInfoImpl(ComponentName name) {
        this.name = name;
    }

    public void setContext(RuntimeContext rc) {
        this.context = rc;
    }

    public Set<RegistrationInfoImpl> getDependsOnMe() {
        return this.dependsOnMe;
    }

    public Set<ComponentName> getWaitsFor() {
        return this.waitsFor;
    }

    @Override
    public final boolean isPersistent() {
        return this.isPersistent;
    }

    public final boolean isPending() {
        return this.waitsFor != null;
    }

    public void destroy() {
        if (this.waitsFor != null) {
            this.waitsFor.clear();
            this.waitsFor = null;
        }
        if (this.requires != null) {
            this.requires.clear();
            this.requires = null;
        }
        if (this.dependsOnMe != null) {
            this.dependsOnMe.clear();
            this.dependsOnMe = null;
        }
        this.component = null;
        this.name = null;
        this.manager = null;
    }

    public final boolean isDisposed() {
        return this.name == null;
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints;
    }

    @Override
    public ComponentInstance getComponent() {
        return this.component;
    }

    @Override
    public ComponentName getName() {
        return this.name;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public ExtensionPointImpl getExtensionPoint(String name) {
        for (ExtensionPointImpl xp : this.extensionPoints) {
            if (!xp.name.equals(name)) continue;
            return xp;
        }
        return null;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public Extension[] getExtensions() {
        return this.extensions;
    }

    @Override
    public Set<ComponentName> getRequiredComponents() {
        return this.requires;
    }

    @Override
    public RuntimeContext getContext() {
        return this.context;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public String toString() {
        return "RegistrationInfo: " + this.name;
    }

    @Override
    public ComponentManager getManager() {
        return this.manager;
    }

    synchronized void register() {
        if (this.state != 0) {
            return;
        }
        this.state = 1;
        this.manager.sendEvent(new ComponentEvent(1, this));
    }

    synchronized void unregister() throws Exception {
        if (this.state == 0) {
            return;
        }
        if (this.state == 3 || this.state == 2) {
            this.unresolve();
        }
        this.state = 0;
        this.manager.sendEvent(new ComponentEvent(6, this));
        this.destroy();
    }

    protected ComponentInstance createComponentInstance() throws Exception {
        try {
            return new ComponentInstanceImpl(this);
        }
        catch (Exception e) {
            String msg = "Failed to instantiate component: " + this.implementation;
            log.error((Object)msg, (Throwable)e);
            msg = msg + " (" + e.toString() + ')';
            Framework.getRuntime().getWarnings().add(msg);
            Framework.handleDevError(e);
            throw e;
        }
    }

    public synchronized void restart() throws Exception {
        this.deactivate();
        this.activate();
    }

    public synchronized void activate() throws Exception {
        String msg;
        if (this.state != 2) {
            return;
        }
        this.component = this.createComponentInstance();
        this.state = 4;
        this.manager.sendEvent(new ComponentEvent(2, this));
        this.component.activate();
        this.state = 3;
        this.manager.sendEvent(new ComponentEvent(4, this));
        if (this.extensions != null) {
            this.checkExtensions();
            for (ExtensionImpl extensionImpl : this.extensions) {
                extensionImpl.setComponent(this.component);
                try {
                    this.manager.registerExtension(extensionImpl);
                }
                catch (Exception e) {
                    msg = "Failed to register extension to: " + extensionImpl.getTargetComponent() + ", xpoint: " + extensionImpl.getExtensionPoint() + " in component: " + extensionImpl.getComponent().getName();
                    log.error((Object)msg, (Throwable)e);
                    msg = msg + " (" + e.toString() + ')';
                    Framework.getRuntime().getWarnings().add(msg);
                    Framework.handleDevError(e);
                }
            }
        }
        ComponentManagerImpl mgr = this.manager;
        Set<Extension> pendingExt = mgr.pendingExtensions.remove(this.name);
        if (pendingExt != null) {
            for (Extension extension : pendingExt) {
                ComponentManagerImpl.loadContributions(this, extension);
                try {
                    this.component.registerExtension(extension);
                }
                catch (Exception e) {
                    msg = "Failed to register extension to: " + extension.getTargetComponent() + ", xpoint: " + extension.getExtensionPoint() + " in component: " + extension.getComponent().getName();
                    log.error((Object)msg, (Throwable)e);
                    msg = msg + " (" + e.toString() + ')';
                    Framework.getRuntime().getWarnings().add(msg);
                    Framework.handleDevError(e);
                }
            }
        }
    }

    public synchronized void deactivate() throws Exception {
        if (this.state != 3) {
            return;
        }
        this.state = 5;
        this.manager.sendEvent(new ComponentEvent(3, this));
        if (this.extensions != null) {
            for (ExtensionImpl xt : this.extensions) {
                try {
                    this.manager.unregisterExtension(xt);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to unregister extension. Contributor: " + xt.getComponent() + " to " + xt.getTargetComponent() + "; xpoint: " + xt.getExtensionPoint()), (Throwable)e);
                    Framework.handleDevError(e);
                }
            }
        }
        this.component.deactivate();
        this.component = null;
        this.state = 2;
        this.manager.sendEvent(new ComponentEvent(5, this));
    }

    synchronized void resolve() throws Exception {
        if (this.state != 1) {
            return;
        }
        this.manager.registerServices(this);
        this.state = 2;
        this.manager.sendEvent(new ComponentEvent(7, this));
        this.activate();
    }

    synchronized void unresolve() throws Exception {
        if (this.state == 1 || this.state == 0) {
            return;
        }
        this.manager.unregisterServices(this);
        if (this.state == 3) {
            this.deactivate();
        }
        this.state = 1;
        this.manager.sendEvent(new ComponentEvent(8, this));
    }

    @Override
    public synchronized boolean isActivated() {
        return this.state == 3;
    }

    @Override
    public synchronized boolean isResolved() {
        return this.state == 2;
    }

    @Override
    public String[] getProvidedServiceNames() {
        if (this.serviceDescriptor != null) {
            return this.serviceDescriptor.services;
        }
        return null;
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    @Override
    public String getImplementation() {
        return this.implementation;
    }

    public void checkExtensions() {
        if (this.extensions == null) {
            return;
        }
        for (ExtensionImpl xt : this.extensions) {
            if (xt.target != null) continue;
            Framework.getRuntime().getWarnings().add("Bad extension declaration (no target attribute specified). Component: " + this.getName());
        }
    }

    @Override
    public URL getXmlFileUrl() {
        return this.xmlFileUrl;
    }
}

