/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.trackers.concurrent;

import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.runtime.trackers.concurrent.ThreadEventHandler;
import org.nuxeo.runtime.trackers.concurrent.ThreadEventListener;

public abstract class ThreadEvent
extends Event {
    public ThreadEvent(Class<? extends ThreadEvent> type, Object source, Object data) {
        super(ThreadEvent.class.getName(), type.getSimpleName(), source, data);
    }

    public abstract void handle(ThreadEventHandler var1);

    public void send() {
        Framework.getService(EventService.class).sendEvent(this);
    }

    public static ThreadEvent onEnter(Object source, boolean isLongRunning) {
        return new EnterEvent(source, isLongRunning);
    }

    public static ThreadEvent onLeave(Object source) {
        return new LeaveEvent(source);
    }

    public static void listen(ThreadEventListener aListener) {
        Framework.getService(EventService.class).addListener(ThreadEvent.class.getName(), aListener);
    }

    public static void ignore(ThreadEventListener aListener) {
        Framework.getService(EventService.class).removeListener(ThreadEvent.class.getName(), aListener);
    }

    protected static class LeaveEvent
    extends ThreadEvent {
        public LeaveEvent(Object source) {
            super(LeaveEvent.class, source, null);
        }

        @Override
        public void handle(ThreadEventHandler handler) {
            handler.onLeave();
        }
    }

    protected static class EnterEvent
    extends ThreadEvent {
        public EnterEvent(Object source, boolean isLongRunning) {
            super(EnterEvent.class, source, isLongRunning);
        }

        public boolean isLongRunning() {
            return (Boolean)this.getData();
        }

        @Override
        public void handle(ThreadEventHandler handler) {
            handler.onEnter((Boolean)this.getData());
        }
    }
}

