/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.nuxeo.runtime.RuntimeMessageHandler;
import org.nuxeo.runtime.model.ComponentManager;

public class RuntimeMessageHandlerImpl
implements RuntimeMessageHandler,
ComponentManager.Listener {
    protected final List<Message> messages = new ArrayList<Message>();
    protected ComponentManagerStep step = ComponentManagerStep.ACTIVATING;

    @Override
    public void addWarning(String message) {
        this.messages.add(new Message(this.step, Level.WARNING, message));
    }

    @Override
    public List<String> getWarnings() {
        return this.messages.stream().filter(msg -> Level.WARNING.equals(msg.getLevel())).map(Message::getMessage).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public void addError(String message) {
        this.messages.add(new Message(this.step, Level.SEVERE, message));
    }

    @Override
    public List<String> getErrors() {
        return this.messages.stream().filter(msg -> Level.SEVERE.equals(msg.getLevel())).map(Message::getMessage).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public void beforeActivation(ComponentManager mgr) {
        this.changeStep(ComponentManagerStep.ACTIVATING);
    }

    @Override
    public void beforeStart(ComponentManager mgr, boolean isResume) {
        this.changeStep(ComponentManagerStep.STARTING);
    }

    @Override
    public void afterStart(ComponentManager mgr, boolean isResume) {
        this.changeStep(ComponentManagerStep.RUNNING);
    }

    @Override
    public void beforeStop(ComponentManager mgr, boolean isStandby) {
        this.changeStep(ComponentManagerStep.STOPPING);
    }

    @Override
    public void beforeDeactivation(ComponentManager mgr) {
        this.changeStep(ComponentManagerStep.DEACTIVATING);
    }

    protected void changeStep(ComponentManagerStep step) {
        this.messages.removeIf(msg -> step.equals((Object)msg.getStep()));
        this.step = step;
    }

    protected static enum ComponentManagerStep {
        ACTIVATING,
        STARTING,
        RUNNING,
        STOPPING,
        DEACTIVATING;

    }

    protected static class Message {
        protected final ComponentManagerStep step;
        protected final Level level;
        protected final String message;

        public Message(ComponentManagerStep step, Level level, String message) {
            this.step = step;
            this.level = level;
            this.message = message;
        }

        public ComponentManagerStep getStep() {
            return this.step;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

