/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.osgi.OSGiComponentLoader;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class OSGiRuntimeActivator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(OSGiRuntimeActivator.class);
    private static OSGiRuntimeActivator instance;
    protected OSGiRuntimeService runtime;
    protected OSGiComponentLoader componentLoader;
    protected ServiceReference pkgAdmin;
    protected BundleContext context;

    public static OSGiRuntimeActivator getInstance() {
        return instance;
    }

    public void start(BundleContext context) {
        log.info((Object)"Starting Runtime Activator");
        instance = this;
        this.context = context;
        this.pkgAdmin = context.getServiceReference(PackageAdmin.class.getName());
        if (Environment.getDefault() == null) {
            throw new IllegalStateException("Environment is not setup");
        }
        this.runtime = new OSGiRuntimeService(context);
        URL config = context.getBundle().getResource("/OSGI-INF/nuxeo.properties");
        if (config != null) {
            System.setProperty("CONFIG_DIR", config.toExternalForm());
        }
        this.initialize(this.runtime);
        Framework.initialize(this.runtime);
        this.componentLoader = new OSGiComponentLoader(this.runtime);
    }

    public void stop(BundleContext context) {
        log.info((Object)"Stopping Runtime Activator");
        instance = null;
        this.pkgAdmin = null;
        this.componentLoader.uninstall();
        this.componentLoader = null;
        try {
            Framework.shutdown();
            this.uninitialize(this.runtime);
        }
        catch (InterruptedException cause) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during shutdown", cause);
        }
        finally {
            this.runtime = null;
            this.context = null;
        }
    }

    public Bundle getBundle(String name) {
        if (this.pkgAdmin == null) {
            return null;
        }
        PackageAdmin pa = (PackageAdmin)this.context.getService(this.pkgAdmin);
        Bundle[] bundles = pa.getBundles(name, null);
        this.context.ungetService(this.pkgAdmin);
        return bundles == null ? null : bundles[0];
    }

    public Class<?> loadClass(String ref) throws ReflectiveOperationException {
        int i = ref.indexOf(58);
        if (i == -1) {
            return Class.forName(ref);
        }
        return this.loadClass(ref.substring(0, i), ref.substring(i + 1));
    }

    public Class<?> loadClass(String bundleName, String className) throws ReflectiveOperationException {
        Bundle bundle = this.getBundle(bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException("No bundle found with name: " + bundleName + ". Unable to load class " + className);
        }
        return bundle.loadClass(className);
    }

    public Object newInstance(String ref) throws ReflectiveOperationException {
        return this.loadClass(ref).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public Object newInstance(String bundleName, String className) throws ReflectiveOperationException {
        return this.loadClass(bundleName, className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void initialize(AbstractRuntimeService runtime) {
    }

    protected void uninitialize(AbstractRuntimeService runtime) {
    }
}

