/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.net.URL;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.osgi.framework.Bundle;

public class OSGiRuntimeContext
extends DefaultRuntimeContext {
    protected final Bundle bundle;
    protected String hostBundleId;
    protected Bundle hostBundle;

    public OSGiRuntimeContext(Bundle bundle) {
        this(Framework.getRuntime(), bundle);
    }

    public OSGiRuntimeContext(RuntimeService runtime, Bundle bundle) {
        super(runtime);
        int p;
        this.bundle = bundle;
        this.hostBundleId = (String)bundle.getHeaders().get("Fragment-Host");
        if (this.hostBundleId != null && (p = this.hostBundleId.indexOf(59)) > -1) {
            this.hostBundleId = this.hostBundleId.substring(0, p);
        }
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        url = this.hostBundleId != null ? this.getHostBundle().getResource(name) : this.bundle.getResource(name);
        if (url == null) {
            url = Framework.getResourceLoader().getResource(name);
        }
        return url;
    }

    @Override
    public URL getLocalResource(String name) {
        URL url = null;
        url = this.hostBundleId != null ? this.getHostBundle().getEntry(name) : this.bundle.getEntry(name);
        if (url == null) {
            url = Framework.getResourceLoader().getResource(name);
        }
        return url;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            if (this.hostBundleId != null) {
                return this.getHostBundle().loadClass(className);
            }
            return this.bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return Framework.getResourceLoader().loadClass(className);
        }
    }

    public Bundle getHostBundle() {
        if (this.hostBundleId != null && this.hostBundle == null && this.runtime instanceof AbstractRuntimeService) {
            this.hostBundle = ((OSGiRuntimeService)this.runtime).findHostBundle(this.bundle);
        }
        return this.hostBundle;
    }
}

