/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime;

public class RuntimeMessage {
    protected final Level level;
    protected final String message;
    protected final Source source;
    protected final String sourceId;

    public RuntimeMessage(Level level, String message, Source source, String sourceId) {
        this.level = level;
        this.message = message;
        this.source = source;
        this.sourceId = sourceId;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Source getSource() {
        if (this.source == null) {
            return Source.UNKNOWN;
        }
        return this.source;
    }

    public String getSourceId() {
        if (this.sourceId == null) {
            return this.getClass().getName();
        }
        return this.sourceId;
    }

    public String toString() {
        return String.format("%s {level=%s, message=%s, source=%s, sourceId=%s}", new Object[]{this.getClass().getName(), this.level, this.message, this.source, this.sourceId});
    }

    public static enum Source {
        UNKNOWN,
        DEPLOYMENT,
        CONFIG,
        BUNDLE,
        COMPONENT,
        EXTENSION,
        CODE;

    }

    public static enum Level {
        ERROR,
        WARNING;

    }
}

