/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.RuntimeMessageHandler;
import org.nuxeo.runtime.model.ComponentManager;

public class RuntimeMessageHandlerImpl
implements RuntimeMessageHandler,
ComponentManager.Listener {
    protected ComponentManagerStep step;
    protected final List<RuntimeMessage> messages = new ArrayList<RuntimeMessage>();

    @Override
    @Deprecated
    public void addWarning(String message) {
        this.addMessage(new RuntimeMessage(RuntimeMessage.Level.WARNING, message, RuntimeMessage.Source.UNKNOWN, null));
    }

    @Override
    @Deprecated
    public List<String> getWarnings() {
        return this.getMessages(RuntimeMessage.Level.WARNING);
    }

    @Override
    @Deprecated
    public void addError(String message) {
        this.addMessage(new RuntimeMessage(RuntimeMessage.Level.ERROR, message, RuntimeMessage.Source.UNKNOWN, null));
    }

    @Override
    @Deprecated
    public List<String> getErrors() {
        return this.getMessages(RuntimeMessage.Level.ERROR);
    }

    @Override
    public void beforeActivation(ComponentManager mgr) {
        this.changeStep(ComponentManagerStep.ACTIVATING);
    }

    @Override
    public void beforeStart(ComponentManager mgr, boolean isResume) {
        this.changeStep(ComponentManagerStep.STARTING);
    }

    @Override
    public void afterStart(ComponentManager mgr, boolean isResume) {
        this.changeStep(ComponentManagerStep.RUNNING);
    }

    @Override
    public void beforeStop(ComponentManager mgr, boolean isStandby) {
        this.changeStep(ComponentManagerStep.STOPPING);
    }

    @Override
    public void beforeDeactivation(ComponentManager mgr) {
        this.changeStep(ComponentManagerStep.DEACTIVATING);
    }

    protected void changeStep(ComponentManagerStep step) {
        if (this.step == ComponentManagerStep.RUNNING) {
            this.messages.removeIf(m -> Set.of(RuntimeMessage.Source.BUNDLE, RuntimeMessage.Source.COMPONENT, RuntimeMessage.Source.EXTENSION).contains((Object)m.getSource()));
        }
        this.step = step;
    }

    @Override
    public void addMessage(RuntimeMessage message) {
        this.messages.add(message);
    }

    @Override
    public List<String> getMessages(RuntimeMessage.Level level) {
        return this.getMessages((RuntimeMessage msg) -> level.equals((Object)msg.getLevel()));
    }

    @Override
    public List<String> getMessages(Predicate<RuntimeMessage> predicate) {
        return this.messages.stream().filter(predicate).map(RuntimeMessage::getMessage).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public List<RuntimeMessage> getRuntimeMessages(RuntimeMessage.Level level) {
        return this.getRuntimeMessages((RuntimeMessage msg) -> level.equals((Object)msg.getLevel()));
    }

    @Override
    public List<RuntimeMessage> getRuntimeMessages(Predicate<RuntimeMessage> predicate) {
        return this.messages.stream().filter(predicate).collect(Collectors.toUnmodifiableList());
    }

    protected static enum ComponentManagerStep {
        ACTIVATING,
        STARTING,
        RUNNING,
        STOPPING,
        DEACTIVATING;

    }
}

