/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.common.xmap.XValueFactory;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.model.impl.XMapContext;

public class ComponentDescriptorReader {
    private final XMap xmap = new XMap();

    public ComponentDescriptorReader() {
        this.xmap.setValueFactory(ComponentName.class, new XValueFactory(){

            public Object deserialize(Context context, String value) {
                return new ComponentName(value);
            }

            public String serialize(Context context, Object value) {
                if (value != null) {
                    return value.toString();
                }
                return null;
            }
        });
        this.xmap.setValueFactory(Version.class, new XValueFactory(){

            public Object deserialize(Context context, String value) {
                return Version.parseString(value);
            }

            public String serialize(Context context, Object value) {
                if (value != null) {
                    return value.toString();
                }
                return null;
            }
        });
        this.xmap.register(RegistrationInfoImpl.class);
    }

    public RegistrationInfoImpl read(RuntimeContext ctx, InputStream in) throws IOException {
        Object[] result = this.xmap.loadAll((Context)new XMapContext(ctx), in);
        if (result.length > 0) {
            if (result[0] instanceof RegistrationInfoImpl) {
                return (RegistrationInfoImpl)result[0];
            }
            throw new IOException(String.format("Expected \"<component>\" tag for component registration, resolved object '%s' instead.", result[0]));
        }
        return null;
    }
}

