/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.persistence;

import java.io.IOException;
import java.util.List;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.persistence.Contribution;
import org.nuxeo.runtime.model.persistence.ContributionPersistenceManager;
import org.nuxeo.runtime.model.persistence.ContributionStorage;
import org.nuxeo.runtime.model.persistence.ContributionStorageDescriptor;
import org.nuxeo.runtime.model.persistence.fs.FileSystemStorage;

public class ContributionPersistenceComponent
extends DefaultComponent
implements ContributionPersistenceManager {
    public static final String STORAGE_XP = "storage";
    protected ContributionStorage storage;
    protected RuntimeContext ctx;

    public static String getComponentName(String contribName) {
        return "config:" + contribName;
    }

    @Override
    public void activate(ComponentContext context) {
        super.activate(context);
        this.ctx = context.getRuntimeContext();
        this.storage = new FileSystemStorage();
    }

    @Override
    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.ctx = null;
        this.storage = null;
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        ContributionStorageDescriptor c = (ContributionStorageDescriptor)contribution;
        try {
            this.storage = (ContributionStorage)c.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeServiceException(e);
        }
    }

    @Override
    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        this.storage = null;
    }

    @Override
    public List<Contribution> getContributions() {
        return this.storage.getContributions();
    }

    @Override
    public Contribution getContribution(String name) {
        return this.storage.getContribution(name);
    }

    @Override
    public Contribution addContribution(Contribution contrib) {
        return this.storage.addContribution(contrib);
    }

    @Override
    public boolean removeContribution(Contribution contrib) {
        return this.storage.removeContribution(contrib);
    }

    @Override
    public boolean isInstalled(Contribution contrib) {
        return this.ctx.isDeployed(contrib);
    }

    @Override
    public synchronized boolean installContribution(Contribution contrib) {
        RegistrationInfo ri;
        try {
            ri = this.ctx.deploy(contrib);
        }
        catch (IOException e) {
            throw new RuntimeServiceException(e);
        }
        if (ri == null) {
            return false;
        }
        ri.setPersistent(true);
        return true;
    }

    @Override
    public boolean uninstallContribution(Contribution contrib) {
        boolean ret = this.isInstalled(contrib);
        try {
            this.ctx.undeploy(contrib);
        }
        catch (IOException e) {
            throw new RuntimeServiceException(e);
        }
        return ret;
    }

    @Override
    public Contribution updateContribution(Contribution contribution) {
        return this.storage.updateContribution(contribution);
    }

    @Override
    public boolean isPersisted(Contribution contrib) {
        return this.storage.getContribution(contrib.getName()) != null;
    }

    @Override
    public void start() {
        for (Contribution c : this.storage.getContributions()) {
            if (c.isDisabled()) continue;
            this.installContribution(c);
        }
    }

    @Override
    public void stop() {
        for (Contribution c : this.storage.getContributions()) {
            if (c.isDisabled()) continue;
            this.uninstallContribution(c);
        }
    }

    @Override
    public void start(ComponentContext context) {
        if (this.storage == null) {
            this.storage = new FileSystemStorage();
            this.start();
        }
    }

    @Override
    public void stop(ComponentContext context) {
        this.stop();
    }
}

