/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.InitialContextAccessor;

public class DataSourceHelper {
    private static final Log log = LogFactory.getLog(DataSourceHelper.class);
    public static final String PREFIX_PROPERTY = "org.nuxeo.runtime.datasource.prefix";
    public static final String DEFAULT_PREFIX = "java:comp/env/jdbc";
    protected static String prefix;

    private DataSourceHelper() {
    }

    public static void autodetectPrefix() {
        String name;
        Context ctx = InitialContextAccessor.getInitialContext();
        String string = name = ctx == null ? null : ctx.getClass().getName();
        if ("org.nuxeo.runtime.jtajca.NamingContext".equals(name)) {
            prefix = DEFAULT_PREFIX;
        } else if ("org.jnp.interfaces.NamingContext".equals(name)) {
            prefix = "java:";
        } else if ("org.apache.naming.SelectorContext".equals(name)) {
            prefix = DEFAULT_PREFIX;
        } else if ("org.mortbay.naming.local.localContextRoot".equals(name)) {
            prefix = "jdbc";
        } else if ("com.sun.enterprise.naming.impl.SerialContext".equals(name)) {
            prefix = DEFAULT_PREFIX;
        } else {
            log.error((Object)("Unknown JNDI Context class: " + name));
            prefix = DEFAULT_PREFIX;
        }
        log.info((Object)("Using JDBC JNDI prefix: " + prefix));
    }

    public static String getDataSourceJNDIPrefix() {
        if (prefix == null) {
            if (Framework.isInitialized()) {
                String configuredPrefix = Framework.getProperty(PREFIX_PROPERTY);
                if (configuredPrefix != null) {
                    prefix = configuredPrefix;
                } else {
                    DataSourceHelper.autodetectPrefix();
                }
            } else {
                prefix = DEFAULT_PREFIX;
            }
        }
        return prefix;
    }

    public static String getDataSourceJNDIName(String partialName) {
        String targetPrefix = DataSourceHelper.getDataSourceJNDIPrefix();
        int idx = partialName.lastIndexOf("/");
        if (idx > 0) {
            partialName = partialName.substring(idx + 1);
        }
        return targetPrefix + "/" + partialName;
    }

    public static DataSource getDataSource(String partialName) throws NamingException {
        InitialContext context = new InitialContext();
        String jndiName = DataSourceHelper.getDataSourceJNDIName(partialName);
        Object resolved = context.lookup(jndiName);
        if (resolved instanceof Reference) {
            try {
                resolved = NamingManager.getObjectInstance(resolved, new CompositeName(jndiName), context, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot get access to " + jndiName, e);
            }
        }
        return (DataSource)resolved;
    }
}

