/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.trackers.files;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileCleaningTracker;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.runtime.trackers.concurrent.ThreadEventHandler;
import org.nuxeo.runtime.trackers.concurrent.ThreadEventListener;
import org.nuxeo.runtime.trackers.files.FileEventHandler;
import org.nuxeo.runtime.trackers.files.FileEventListener;

public class FileEventTracker
extends DefaultComponent {
    protected final GCDelegate gc = new GCDelegate();
    protected static FileEventTracker self;
    protected final ThreadLocal<ThreadDelegate> threads = new ThreadLocal();
    protected final ThreadEventListener threadsListener = new ThreadEventListener(new ThreadEventHandler(){

        @Override
        public void onEnter(boolean isLongRunning) {
            FileEventTracker.this.setThreadDelegate(isLongRunning);
        }

        @Override
        public void onLeave() {
            FileEventTracker.this.resetThreadDelegate();
        }
    });
    protected final FileEventListener filesListener = new FileEventListener(new FileEventHandler(){

        @Override
        public void onFile(File file, Object marker) {
            FileEventTracker.this.onContext().onFile(file, marker);
        }
    });

    @Override
    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        self = this;
        this.filesListener.install();
        this.setThreadDelegate(false);
    }

    @Override
    public int getApplicationStartedOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void applicationStarted(ComponentContext context) throws Exception {
        this.resetThreadDelegate();
        Framework.addListener(new RuntimeServiceListener(){

            @Override
            public void handleEvent(RuntimeServiceEvent event) {
                if (event.id != 2) {
                    return;
                }
                Framework.removeListener(this);
                FileEventTracker.this.setThreadDelegate(false);
            }
        });
    }

    @Override
    public void deactivate(ComponentContext context) throws Exception {
        this.resetThreadDelegate();
        if (Framework.getService(EventService.class) != null) {
            if (this.threadsListener.isInstalled()) {
                this.threadsListener.uninstall();
            }
            this.filesListener.uninstall();
        }
        self = null;
        super.deactivate(context);
    }

    @Override
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (contribution instanceof EnableThreadsTracking) {
            this.threadsListener.install();
        } else {
            super.registerContribution(contribution, extensionPoint, contributor);
        }
    }

    protected FileEventHandler onContext() {
        FileEventHandler actual = this.threads.get();
        if (actual == null) {
            actual = this.gc;
        }
        return actual;
    }

    protected void setThreadDelegate(boolean isLongRunning) {
        if (this.threads.get() != null) {
            throw new IllegalStateException("Thread delegate already installed");
        }
        this.threads.set(new ThreadDelegate(isLongRunning));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetThreadDelegate() throws IllegalStateException {
        ThreadDelegate actual = this.threads.get();
        if (actual == null) {
            throw new IllegalStateException("Thread delegate not installed");
        }
        try {
            for (File file : actual.files) {
                file.delete();
            }
        }
        finally {
            this.threads.remove();
        }
    }

    @XObject(value="enableThreadsTracking")
    public static class EnableThreadsTracking {
    }

    protected class ThreadDelegate
    implements FileEventHandler {
        protected final boolean isLongRunning;
        protected final Thread owner = Thread.currentThread();
        protected final Set<File> files = new HashSet<File>();

        protected ThreadDelegate(boolean isLongRunning) {
            this.isLongRunning = isLongRunning;
        }

        @Override
        public void onFile(File file, Object marker) {
            if (!this.owner.equals(Thread.currentThread())) {
                return;
            }
            if (this.isLongRunning) {
                FileEventTracker.this.gc.onFile(file, marker);
            }
            this.files.add(file);
        }
    }

    protected class GCDelegate
    implements FileEventHandler {
        protected FileCleaningTracker delegate = new FileCleaningTracker();

        protected GCDelegate() {
        }

        @Override
        public void onFile(File file, Object marker) {
            this.delegate.track(file, marker);
        }
    }
}

