/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.sessioninspector.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.sessioninspector.jsf.model.ObjectStatistics;
import org.nuxeo.runtime.javaagent.AgentLoader;

public class ObjectVisitor {
    protected final Map<Object, Object> visited = new IdentityHashMap<Object, Object>();

    public Collection<ObjectStatistics> getObjectStatisticsList() {
        HashMap<String, ObjectStatistics> map = new HashMap<String, ObjectStatistics>();
        for (Object o : this.visited.keySet()) {
            String type = o.getClass().getCanonicalName();
            ObjectStatistics os = (ObjectStatistics)map.get(type);
            if (os == null) {
                os = new ObjectStatistics(type, 1L, AgentLoader.INSTANCE.getSizer().sizeOf(o));
                map.put(type, os);
                continue;
            }
            os.setNbInstance(os.getNbInstance() + 1L);
            os.setCumulatedSize(os.getCumulatedSize() + AgentLoader.INSTANCE.getSizer().sizeOf(o));
        }
        return map.values();
    }

    public Map<Object, Object> getVisited() {
        return this.visited;
    }

    public void visit(Object each) {
        if (each == null) {
            return;
        }
        if (this.visited.containsKey(each)) {
            return;
        }
        this.visited.put(each, each);
        Class<?> eachType = each.getClass();
        if (eachType.isArray()) {
            if (eachType.getComponentType().isPrimitive()) {
                return;
            }
            for (int i = 0; i < Array.getLength(each); ++i) {
                this.visit(Array.get(each, i));
            }
        } else {
            this.visit(each, eachType);
        }
    }

    protected void visit(Object each, Class<?> eachType) {
        if (eachType.equals(Object.class)) {
            return;
        }
        for (Field eachField : eachType.getDeclaredFields()) {
            this.visit(each, eachField);
        }
        this.visit(each, eachType.getSuperclass());
    }

    protected void visit(Object each, Field eachField) {
        if ((eachField.getModifiers() & 8) != 0) {
            return;
        }
        if (eachField.getType().isPrimitive()) {
            return;
        }
        boolean oldAccessible = eachField.isAccessible();
        eachField.setAccessible(true);
        try {
            this.visit(eachField.get(each));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception trying to access field " + eachField, e);
        }
        finally {
            eachField.setAccessible(oldAccessible);
        }
    }
}

