/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.sessioninspector.jsf.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.sessioninspector.jsf.StateReferenceHelper;
import org.nuxeo.ecm.platform.sessioninspector.jsf.model.ObjectStatistics;
import org.nuxeo.runtime.javaagent.AgentLoader;

public class MonitorNode {
    protected MonitorNode parent = null;
    protected String id = null;
    protected Object stateReference = null;
    protected final String type;
    protected List<MonitorNode> children = null;
    protected String path = null;
    protected Integer depth = null;
    protected Long size = null;
    protected Map<String, ObjectStatistics> objMapStat;

    public MonitorNode(MonitorNode parent, Object rawHierarchy, Object[] rawState) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.parent = parent;
        this.id = StateReferenceHelper.getIdForNode(rawHierarchy);
        this.stateReference = rawState[0];
        this.type = StateReferenceHelper.getTypeForNode(rawHierarchy);
        this.children = new ArrayList<MonitorNode>();
        List<?> childrenOfCurrent = StateReferenceHelper.getChildrenForNode(rawHierarchy);
        if (childrenOfCurrent != null) {
            this.children = new ArrayList<MonitorNode>(childrenOfCurrent.size());
            for (int i = 0; i < childrenOfCurrent.size(); ++i) {
                this.children.add(new MonitorNode(this, childrenOfCurrent.get(i), (Object[])((Object[])rawState[1])[i]));
            }
        }
    }

    public MonitorNode(Object rawHierarchy, Object[] rawState) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this(null, rawHierarchy, rawState);
    }

    public MonitorNode getChild(String id) {
        for (MonitorNode child : this.children) {
            if (!child.getId().equals(id)) continue;
            return child;
        }
        return null;
    }

    public MonitorNode getChild(String[] path) {
        MonitorNode n;
        if (path == null || path.length == 0 || !path[0].equals(this.id)) {
            return null;
        }
        if (path.length == 1) {
            return this;
        }
        MonitorNode result = null;
        String[] subArray = Arrays.copyOfRange(path, 1, path.length);
        Iterator<MonitorNode> i$ = this.children.iterator();
        while (i$.hasNext() && (result = (n = i$.next()).getChild(subArray)) == null) {
        }
        return result;
    }

    public int getCumulatedDepth() {
        int count = 1;
        for (MonitorNode child : this.children) {
            count += child.getCumulatedDepth();
        }
        return count;
    }

    public Long getCumulatedSize() {
        Long count = this.getSize();
        for (MonitorNode child : this.children) {
            count = count + child.getCumulatedSize();
        }
        return count;
    }

    public int getDepth() {
        if (this.depth == null) {
            this.depth = this.parent == null ? Integer.valueOf(1) : Integer.valueOf(this.parent.getDepth() + 1);
        }
        return this.depth;
    }

    public String getId() {
        return this.id;
    }

    public int getMaxDepth() {
        int max = 1;
        for (MonitorNode child : this.children) {
            int temp = 1 + child.getMaxDepth();
            if (temp <= max) continue;
            max = temp;
        }
        return max;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.parent == null ? this.id : this.parent.getPath() + ":" + this.id;
        }
        return this.path;
    }

    public Long getSize() {
        if (this.size == null) {
            Long temp;
            this.size = temp = Long.valueOf(AgentLoader.INSTANCE.getSizer().deepSizeOf(this.stateReference) / 8L);
        }
        return this.size;
    }

    public Object getStateReference() {
        return this.stateReference;
    }

    public String getType() {
        return this.type;
    }

    public String getView() {
        if (this.type != null && this.type.endsWith("UIAliasHolder")) {
            return "uiAliasHolder";
        }
        return "uiComponent";
    }

    public List<MonitorNode> toList() {
        ArrayList<MonitorNode> result = new ArrayList<MonitorNode>();
        result.add(this);
        for (MonitorNode child : this.children) {
            result.addAll(child.toList());
        }
        return result;
    }

    public String toString() {
        if (this.stateReference != null) {
            return this.stateReference.toString();
        }
        return null;
    }
}

