/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.context.extensions;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.context.DocumentWrapper;

public class ContextFunctions {
    protected final DocumentModel doc;
    protected final DocumentWrapper nuxeoWrapper;

    public ContextFunctions(DocumentModel doc, DocumentWrapper nuxeoWrapper) {
        this.doc = doc;
        this.nuxeoWrapper = nuxeoWrapper;
    }

    public String getVocabularyTranslatedLabel(String voc_name, String key, String lang) throws Exception {
        String labelKey = this.getVocabularyLabel(voc_name, key);
        if (labelKey == null) {
            return null;
        }
        Locale locale = new Locale(lang);
        if (voc_name.contains("/") && labelKey.contains(" / ")) {
            String[] parts = labelKey.split(" \\/ ");
            String result = "";
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    result = result + " / ";
                }
                try {
                    result = result + I18NUtils.getMessageString((String)"messages", (String)parts[i], null, (Locale)locale);
                    continue;
                }
                catch (MissingResourceException e) {
                    result = result + parts[i];
                }
            }
            return result;
        }
        try {
            return I18NUtils.getMessageString((String)"messages", (String)labelKey, null, (Locale)locale);
        }
        catch (MissingResourceException e) {
            return labelKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVocabularyLabel(String voc_name, String key) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        if (ds == null) {
            return key;
        }
        ArrayList<String> vocs = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        if (voc_name.contains("/")) {
            String[] parts;
            for (String part : parts = voc_name.split("\\/")) {
                vocs.add(part);
            }
            for (String part : parts = key.split("\\/")) {
                keys.add(part);
            }
        } else {
            vocs.add(voc_name);
            keys.add(key);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < vocs.size(); ++i) {
            Directory dir;
            String schema;
            String voc = (String)vocs.get(i);
            String keyValue = (String)keys.get(i);
            if (!ds.getDirectoryNames().contains(voc) || !"vocabulary".equals(schema = (dir = ds.getDirectory(voc)).getSchema()) && !"xvocabulary".equals(schema)) continue;
            Session session = dir.getSession();
            try {
                DocumentModel entry = session.getEntry(keyValue);
                if (entry == null) continue;
                values.add((String)entry.getProperty(schema, "label"));
                continue;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        if (values.size() == 0) {
            return key;
        }
        if (values.size() == 1) {
            return (String)values.get(0);
        }
        String result = "";
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                result = result + " / ";
            }
            result = result + (String)values.get(i);
        }
        return result;
    }

    public String formatDate(Object calendar) {
        return this.formatDate(calendar, "MM/dd/yyyy");
    }

    public String formatDateTime(Object calendar) {
        return this.formatDate(calendar, "MM/dd/yyyy HH:mm:ss");
    }

    public String formatTime(Object calendar) {
        return this.formatDate(calendar, "HH:mm:ss");
    }

    public String formatDate(Object calendar, String format) {
        Date dt = null;
        if (calendar instanceof Calendar) {
            dt = ((Calendar)calendar).getTime();
        } else if (calendar instanceof Date) {
            dt = (Date)calendar;
        }
        if (dt == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(calendar);
    }
}

