/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.document.AbstractXDocReport;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.document.odt.ODTConstants;
import fr.opensagres.xdocreport.document.odt.images.ODTImageRegistry;
import fr.opensagres.xdocreport.document.odt.preprocessor.ODTManifestXMLProcessor;
import fr.opensagres.xdocreport.document.odt.preprocessor.ODTPreprocessor;
import fr.opensagres.xdocreport.document.odt.preprocessor.ODTStylesPreprocessor;

public class ODTReport
extends AbstractXDocReport {
    private static final long serialVersionUID = 5974669564624835649L;
    private static final String[] DEFAULT_XML_ENTRIES = new String[]{"content.xml", "styles.xml", "META-INF/manifest.xml"};

    public String getKind() {
        return DocumentKind.ODT.name();
    }

    public MimeMapping getMimeMapping() {
        return ODTConstants.MIME_MAPPING;
    }

    protected void registerPreprocessors() {
        super.addPreprocessor("content.xml", ODTPreprocessor.INSTANCE);
        super.addPreprocessor("META-INF/manifest.xml", ODTManifestXMLProcessor.INSTANCE);
        super.addPreprocessor("styles.xml", ODTStylesPreprocessor.INSTANCE);
    }

    protected String[] getDefaultXMLEntries() {
        return DEFAULT_XML_ENTRIES;
    }

    protected IImageRegistry createImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider) {
        return new ODTImageRegistry(readerProvider, writerProvider, outputStreamProvider, this.getFieldsMetadata());
    }
}

