/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.utils;

import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.Base64Exception;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Logger;

public final class Base64Utility {
    private static final Logger LOG;
    private static final char[] BCS;
    private static final char PAD = '=';
    private static final int BDTSIZE = 128;
    private static final byte[] BDT;
    private static final int PAD_SIZE0 = 1;
    private static final int PAD_SIZE4 = 2;
    private static final int PAD_SIZE8 = 3;

    private Base64Utility() {
    }

    public static byte[] decodeChunk(char[] id, int o, int l) throws Base64Exception {
        if (l - o < 4) {
            return null;
        }
        char[] ib = new char[4];
        int ibcount = 0;
        int octetCount = 3 * (l / 4);
        if (id[l - 1] == '=') {
            octetCount -= id[l - 2] == '=' ? 2 : 1;
        }
        byte[] ob = new byte[octetCount];
        int obcount = 0;
        for (int i = o; i < o + l && i < id.length; ++i) {
            if (id[i] != '=' && (id[i] >= BDT.length || BDT[id[i]] == 127)) continue;
            ib[ibcount++] = id[i];
            if (ibcount != ib.length) continue;
            ibcount = 0;
            obcount += Base64Utility.processEncodeme(ib, ob, obcount);
        }
        if (obcount != ob.length) {
            byte[] tmp = new byte[obcount];
            System.arraycopy(ob, 0, tmp, 0, obcount);
            ob = tmp;
        }
        return ob;
    }

    public static byte[] decode(String id) throws Base64Exception {
        try {
            char[] cd = id.toCharArray();
            return Base64Utility.decodeChunk(cd, 0, cd.length);
        }
        catch (Exception e) {
            LOG.warning("Invalid base64 encoded string : " + id);
            throw new Base64Exception("Runtime exception in Base64Utility.decode() during output", e);
        }
    }

    public static void decode(char[] id, int o, int l, OutputStream ostream) throws Base64Exception {
        try {
            ostream.write(Base64Utility.decodeChunk(id, o, l));
        }
        catch (Exception e) {
            LOG.warning("Invalid base64 encoded string : " + new String(id));
            throw new Base64Exception("Runtime exception in Base64Utility.decode() during output", e);
        }
    }

    public static void decode(String id, OutputStream ostream) throws Base64Exception {
        try {
            char[] cd = id.toCharArray();
            ostream.write(Base64Utility.decodeChunk(cd, 0, cd.length));
        }
        catch (IOException ioe) {
            throw new Base64Exception("decode() to outstream raised IOException", ioe);
        }
        catch (Exception e) {
            LOG.warning("Invalid base64 encoded string : " + id);
            throw new Base64Exception("Runtime exception in Base64Utility.decode() during output", e);
        }
    }

    public static String encode(byte[] id) {
        char[] cd = Base64Utility.encodeChunk(id, 0, id.length);
        return new String(cd, 0, cd.length);
    }

    public static char[] encodeChunk(byte[] id, int o, int l) {
        int i;
        int rest;
        if (l <= 0) {
            return null;
        }
        char[] out = (l - o) % 3 == 0 ? new char[l / 3 * 4] : new char[l / 3 * 4 + 4];
        int rindex = o;
        int windex = 0;
        for (rest = l - o; rest >= 3; rest -= 3) {
            i = ((id[rindex] & 0xFF) << 16) + ((id[rindex + 1] & 0xFF) << 8) + (id[rindex + 2] & 0xFF);
            out[windex++] = BCS[i >> 18];
            out[windex++] = BCS[i >> 12 & 0x3F];
            out[windex++] = BCS[i >> 6 & 0x3F];
            out[windex++] = BCS[i & 0x3F];
            rindex += 3;
        }
        if (rest == 1) {
            i = id[rindex] & 0xFF;
            out[windex++] = BCS[i >> 2];
            out[windex++] = BCS[i << 4 & 0x3F];
            out[windex++] = 61;
            out[windex++] = 61;
        } else if (rest == 2) {
            i = ((id[rindex] & 0xFF) << 8) + (id[rindex + 1] & 0xFF);
            out[windex++] = BCS[i >> 10];
            out[windex++] = BCS[i >> 4 & 0x3F];
            out[windex++] = BCS[i << 2 & 0x3F];
            out[windex++] = 61;
        }
        return out;
    }

    public static void encodeChunk(byte[] id, int o, int l, OutputStream ostream) throws Base64Exception {
        try {
            ostream.write(new String(Base64Utility.encodeChunk(id, o, l)).getBytes());
        }
        catch (IOException e) {
            throw new Base64Exception("encode() to outstream raised IOException", e);
        }
    }

    public static void encode(byte[] id, int o, int l, Writer writer) throws Base64Exception {
        try {
            writer.write(Base64Utility.encodeChunk(id, o, l));
        }
        catch (IOException e) {
            throw new Base64Exception("encode() to Writer raised exception", e);
        }
    }

    private static int processEncodeme(char[] ib, byte[] ob, int p) throws Base64Exception {
        int spad = 3;
        if (ib[3] == '=') {
            spad = 2;
        }
        if (ib[2] == '=') {
            spad = 1;
        }
        byte b0 = BDT[ib[0]];
        byte b1 = BDT[ib[1]];
        byte b2 = BDT[ib[2]];
        byte b3 = BDT[ib[3]];
        switch (spad) {
            case 1: {
                ob[p] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                return 1;
            }
            case 2: {
                ob[p++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                ob[p] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                return 2;
            }
            case 3: {
                ob[p++] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                ob[p++] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                ob[p] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
                return 3;
            }
        }
        throw new IllegalStateException();
    }

    static {
        int i;
        LOG = LogUtils.getLogger(Base64Utility.class);
        BCS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        BDT = new byte[128];
        for (i = 0; i < 128; ++i) {
            Base64Utility.BDT[i] = 127;
        }
        for (i = 0; i < BCS.length; ++i) {
            Base64Utility.BDT[Base64Utility.BCS[i]] = (byte)i;
        }
    }
}

