/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.convert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.extension.ExternalConverter;
import org.nuxeo.runtime.api.Framework;

public class AnyToODTConverter
implements ExternalConverter {
    protected ConversionService getConversionService() {
        return (ConversionService)Framework.getLocalService(ConversionService.class);
    }

    protected List<String> getConverterChain(String srcMT) {
        ArrayList<String> subConverters = new ArrayList<String>();
        if (srcMT == null) {
            return null;
        }
        if (srcMT.equals("text/x-web-markdown")) {
            subConverters.add("md2html");
        }
        subConverters.add("sdttext2odt");
        return subConverters;
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Blob sourceBlob;
        try {
            sourceBlob = blobHolder.getBlob();
        }
        catch (Exception e) {
            throw new ConversionException("Can not fetch blob", e);
        }
        List<String> subConverters = this.getConverterChain(sourceBlob.getMimeType());
        if (subConverters == null) {
            throw new ConversionException("Can not find suitable underlying converters to handle html preview");
        }
        BlobHolder result = blobHolder;
        for (String converterName : subConverters) {
            result = this.getConversionService().convert(converterName, result, parameters);
        }
        return result;
    }

    public void init(ConverterDescriptor descriptor) {
    }

    public ConverterCheckResult isConverterAvailable() {
        try {
            return this.getConversionService().isConverterAvailable("sdttext2odt");
        }
        catch (ConversionException e) {
            ConverterCheckResult result = new ConverterCheckResult();
            result.setAvailable(false);
            return result;
        }
    }
}

