/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.remoting.resources.services.jaxrs;

import fr.opensagres.xdocreport.remoting.resources.domain.LargeBinaryData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
public class LargeBinaryDataMessageBodyWriter
implements MessageBodyWriter<LargeBinaryData> {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return LargeBinaryData.class.isAssignableFrom(type);
    }

    public long getSize(LargeBinaryData t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        long n = t.getLength();
        return n <= 0L ? -1L : n;
    }

    public void writeTo(LargeBinaryData t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        InputStream content = t.getContent();
        httpHeaders.add((Object)"Content-Disposition", (Object)("attachement;filename=" + t.getFileName()));
        httpHeaders.add((Object)"Content-Type", (Object)t.getMimeType());
        httpHeaders.add((Object)"X-resourceId", (Object)t.getResourceId());
        this.copyLarge(content, entityStream);
        entityStream.flush();
    }

    private long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

