/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.preprocessor.sax;

import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedAttribute;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedEndTagElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedStartTagElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedTagElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.IBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.ISavable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedElement
implements IBufferedRegion {
    private final BufferedElement parent;
    private final String name;
    private final String startTagElementName;
    private final String endTagElementName;
    protected final BufferedStartTagElement startTagElement;
    protected final BufferedEndTagElement endTagElement;
    private BufferedTagElement currentTagElement;
    private final Attributes attributes;
    private Collection<BufferedAttribute> dynamicAttributes = null;
    private boolean reseted;
    private Map<String, String> data;

    public BufferedElement(BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        this.parent = parent;
        this.name = name;
        this.startTagElementName = "<" + name + ">";
        this.endTagElementName = "</" + name + ">";
        this.attributes = attributes;
        this.startTagElement = new BufferedStartTagElement(this);
        this.endTagElement = new BufferedEndTagElement(this);
        this.currentTagElement = this.startTagElement;
        this.reseted = false;
    }

    public boolean match(String name) {
        if (name == null) {
            return false;
        }
        return name.equals(this.name);
    }

    public BufferedStartTagElement getStartTagElement() {
        return this.startTagElement;
    }

    public BufferedEndTagElement getEndTagElement() {
        return this.endTagElement;
    }

    public void setContentBeforeStartTagElement(String before) {
        this.startTagElement.setBefore(before);
    }

    public void setContentAfterEndTagElement(String after) {
        this.endTagElement.setAfter(after);
    }

    @Override
    public BufferedElement getParent() {
        return this.parent;
    }

    private BufferedTagElement getCurrentTagElement() {
        return this.currentTagElement;
    }

    @Override
    public void save(Writer writer) throws IOException {
        this.getStartTagElement().save(writer);
        this.getEndTagElement().save(writer);
    }

    @Override
    public void addRegion(ISavable region) {
        this.getCurrentTagElement().addRegion(region);
    }

    @Override
    public boolean isString() {
        return this.getCurrentTagElement().isString();
    }

    @Override
    public void append(String content) {
        this.getCurrentTagElement().append(content);
    }

    @Override
    public void append(char[] ch, int start, int length) {
        this.getCurrentTagElement().append(ch, start, length);
    }

    @Override
    public void append(char c) {
        this.getCurrentTagElement().append(c);
    }

    public void reset() {
        this.startTagElement.reset();
        this.endTagElement.reset();
        this.reseted = true;
    }

    public boolean isReseted() {
        return this.reseted;
    }

    public void removeAll(Collection<BufferedElement> elements) {
        BufferedTagElement tagElement = null;
        for (BufferedElement element : elements) {
            tagElement = element.getStartTagElement();
            if (tagElement != null) {
                this.getStartTagElement().regions.remove(tagElement);
            }
            if ((tagElement = element.getEndTagElement()) == null) continue;
            this.getStartTagElement().regions.remove(tagElement);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.save(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    public BufferedElement getOwnerElement() {
        return this;
    }

    public BufferedElement findParent(String name) {
        return this.findParent(this, name);
    }

    public BufferedElement findParent(BufferedElement element, String name) {
        if (element == null) {
            return null;
        }
        if (element.match(name)) {
            return element;
        }
        return this.findParent(element.getParent(), name);
    }

    public List<BufferedElement> findChildren(String name) {
        return this.findChildren(this, name);
    }

    public List<BufferedElement> findChildren(BufferedElement element, String name) {
        ArrayList<BufferedElement> elements = new ArrayList<BufferedElement>();
        List regions = element.getStartTagElement().regions;
        this.findChildren(regions, name, elements);
        return elements;
    }

    public BufferedElement findFirstChild(String name) {
        return this.findFirstChild(this, name);
    }

    public BufferedElement findFirstChild(BufferedElement element, String name) {
        return this.findChildAt(element, name, 0);
    }

    public BufferedElement findChildAt(String name, int index) {
        return this.findChildAt(this, name, index);
    }

    public BufferedElement findChildAt(BufferedElement element, String name, int index) {
        List<BufferedElement> elements = this.findChildren(element, name);
        if (index < elements.size()) {
            return elements.get(index);
        }
        return null;
    }

    private void findChildren(List<ISavable> regions, String name, List<BufferedElement> elements) {
        for (ISavable region : regions) {
            if (!(region instanceof IBufferedRegion)) continue;
            IBufferedRegion r = (IBufferedRegion)region;
            if (r.getOwnerElement().match(name) && !elements.contains(r.getOwnerElement())) {
                elements.add(r.getOwnerElement());
            }
            if (!(r instanceof BufferedRegion)) continue;
            this.findChildren(((BufferedRegion)r).regions, name, elements);
        }
    }

    public void start() {
        this.currentTagElement = this.startTagElement;
    }

    public void end() {
        this.currentTagElement = this.endTagElement;
    }

    public boolean isEnded() {
        return this.currentTagElement == this.endTagElement;
    }

    public String getStartTagElementName() {
        return this.startTagElementName;
    }

    public String getEndTagElementName() {
        return this.endTagElementName;
    }

    public void setTextContent(String content) {
        if (this.isEnded()) {
            this.reset();
            this.getStartTagElement().append(this.getStartTagElementName());
            this.getStartTagElement().append(content);
            this.getEndTagElement().append(this.getEndTagElementName());
        } else {
            this.getCurrentTagElement().append(content);
        }
    }

    public String getTextContent() {
        StringWriter writer = new StringWriter();
        try {
            this.save(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String textContent = writer.toString();
        if (textContent.startsWith(this.getStartTagElementName())) {
            textContent = textContent.substring(this.getStartTagElementName().length(), textContent.length());
        }
        if (textContent.endsWith(this.getEndTagElementName())) {
            textContent = textContent.substring(0, textContent.length() - this.getStartTagElementName().length() - 1);
        }
        return textContent;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void registerDynamicAttributes() {
        if (this.dynamicAttributes == null) {
            return;
        }
        for (BufferedAttribute attribute : this.dynamicAttributes) {
            this.getCurrentTagElement().addRegion(attribute);
        }
    }

    public BufferedAttribute setAttribute(String name, String value) {
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new ArrayList<BufferedAttribute>();
        }
        BufferedAttribute attribute = new BufferedAttribute(this, name, value);
        this.dynamicAttributes.add(attribute);
        return attribute;
    }

    public String getName() {
        return this.name;
    }

    public String getInnerText() {
        StringWriter writer = new StringWriter();
        List regions = this.startTagElement.regions;
        boolean startTagParsing = true;
        for (ISavable region : regions) {
            if (startTagParsing && region instanceof BufferedStartTagElement) {
                startTagParsing = false;
            }
            if (startTagParsing) continue;
            try {
                region.save(writer);
            }
            catch (IOException e) {}
        }
        return writer.toString();
    }

    public void setInnerText(String innerText) {
        ArrayList<ISavable> regionsToAdd = new ArrayList<ISavable>();
        List regions = this.startTagElement.regions;
        boolean startTagParsing = true;
        for (ISavable region : regions) {
            boolean bl = startTagParsing = !(region instanceof BufferedStartTagElement);
            if (!startTagParsing) break;
            regionsToAdd.add(region);
        }
        this.startTagElement.reset();
        this.startTagElement.regions.addAll(regionsToAdd);
        this.startTagElement.append(innerText);
    }

    public String get(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public void put(String key, String value) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.put(key, value);
    }
}

