/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.xdocreport;

import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public class FieldDefinitionGenerator {
    public static String generate(String type) {
        SchemaManager sm = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType docType = sm.getDocumentType(type);
        return FieldDefinitionGenerator.generate(docType.getSchemaNames());
    }

    public static String generate(DocumentModel doc) {
        return FieldDefinitionGenerator.generate(doc.getSchemas());
    }

    protected static String generate(String[] schemaNames) {
        FieldsMetadata fieldsMetadata = new FieldsMetadata(TemplateEngineKind.Freemarker.name());
        for (String schemaName : schemaNames) {
            SchemaManager sm = (SchemaManager)Framework.getService(SchemaManager.class);
            Schema schema = sm.getSchema(schemaName);
            for (Field field : schema.getFields()) {
                String name = field.getName().getLocalName();
                String fieldName = "doc." + schemaName + "." + name;
                if (field.getType().isListType()) {
                    fieldsMetadata.addField(fieldName, Boolean.valueOf(true), null, null, null);
                    continue;
                }
                fieldsMetadata.addField(fieldName, Boolean.valueOf(false), null, null, null);
                if (!field.getType().isComplexType()) continue;
                ComplexType ct = (ComplexType)field.getType();
                if ("content".equals(ct.getName())) {
                    fieldsMetadata.addField(fieldName + ".filename", Boolean.valueOf(false), null, null, null);
                    continue;
                }
                for (Field subField : ct.getFields()) {
                    fieldsMetadata.addField(fieldName + "." + subField.getName().getLocalName(), Boolean.valueOf(false), null, null, null);
                }
            }
        }
        fieldsMetadata.addField("doc.versionLabel", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.id", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.name", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.title", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.pathAsString", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.type", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.schemas", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("doc.facets", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("doc.locked", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.lockInfo", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.lockInfo.owner", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.lockInfo.created", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.checkedOut", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("doc.", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("principal.firstName", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("principal.lastName", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("principal.company", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("principal.email", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("principal.name", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("auditEntries", Boolean.valueOf(false), null, null, null);
        fieldsMetadata.addField("auditEntries.id", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.principalName", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.eventId", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.eventDate", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.docUUID", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.docPath", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.docType", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.category", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.comment", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.docLifeCycle", Boolean.valueOf(true), null, null, null);
        fieldsMetadata.addField("auditEntries.repositoryId", Boolean.valueOf(true), null, null, null);
        StringWriter writer = new StringWriter();
        try {
            fieldsMetadata.saveXML((Writer)writer, true);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        return writer.getBuffer().toString();
    }
}

