/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html;

import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.CachingDef;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.html.WebLength;
import org.nuxeo.theme.presets.PresetManager;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.properties.OrderedProperties;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.uids.Identifiable;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final String[] lengthUnits = new String[]{"%", "em", "px", "ex", "pt", "in", "cm", "mm", "pc"};
    private static final Pattern firstTagPattern = Pattern.compile("<(.*?)>", 32);
    private static final Pattern otherTagsPattern = Pattern.compile("<.*?>(.*)", 32);
    private static final Pattern classAttrPattern = Pattern.compile(" class=\"(.*?)\"", 32);
    private static final Pattern emptyCssSelectorPattern = Pattern.compile("(.*?)\\{(.*?)\\}", 32);
    private static final Pattern hexColorPattern = Pattern.compile(".*?#(\\p{XDigit}{3,6}).*?", 32);
    private static final Pattern rgbColorPattern = Pattern.compile(".*?rgb\\s*\\(\\s*([0-9,\\s]+)\\s*\\).*?", 32);
    private static final Pattern rgbDigitPattern = Pattern.compile("([0-9]{1,3},[0-9]{1,3},[0-9]{1,3})");
    public static final Pattern PRESET_PATTERN = Pattern.compile("^\"(.*?)\"$", 32);
    private static final String EMPTY_CSS_SELECTOR = "EMPTY";
    private static final String CLASS_ATTR_PREFIX = "nxStyle";
    private static final String CSS_PROPERTIES_RESOURCE = "/nxthemes/html/styles/css.properties";
    private static final Properties cssProperties = new OrderedProperties();

    private Utils() {
    }

    public static Properties getCssProperties() {
        return cssProperties;
    }

    public static String toJson(Object object) {
        return JSONObject.fromObject((Object)object).toString();
    }

    public static String addWebLengths(String length1, String length2) {
        WebLength webLength1 = Utils.getWebLength(length1);
        WebLength webLength2 = Utils.getWebLength(length2);
        if (!webLength1.unit.equals(webLength2.unit)) {
            return null;
        }
        return new WebLength(webLength1.value + webLength2.value, webLength1.unit).toString();
    }

    public static String substractWebLengths(String length1, String length2) {
        WebLength webLength1 = Utils.getWebLength(length1);
        WebLength webLength2 = Utils.getWebLength(length2);
        if (!webLength1.unit.equals(webLength2.unit)) {
            return null;
        }
        return new WebLength(webLength1.value - webLength2.value, webLength1.unit).toString();
    }

    public static String divideWebLength(String length, int divider) {
        if (divider <= 0) {
            return null;
        }
        WebLength webLength = Utils.getWebLength(length);
        if (webLength != null) {
            return new WebLength(webLength.value / divider, webLength.unit).toString();
        }
        return null;
    }

    public static WebLength getWebLength(String length) {
        Integer value = null;
        String unit = null;
        for (String lengthUnit : lengthUnits) {
            if (!length.endsWith(lengthUnit)) continue;
            unit = lengthUnit;
            try {
                value = Integer.valueOf(length.substring(0, length.length() - lengthUnit.length()));
            }
            catch (NumberFormatException e) {
                log.error((Object)"Could not convert web lengths to integers", (Throwable)e);
            }
            break;
        }
        if (value != null && unit != null) {
            return new WebLength(value, unit);
        }
        return null;
    }

    public static String toCamelCase(String value) {
        if (value == null || value.trim().equals("")) {
            return value;
        }
        String newValue = value.replaceAll("[^\\p{Alnum}]+", " ");
        StringBuilder sb = new StringBuilder();
        String[] parts = newValue.trim().split("\\s+");
        sb.append(parts[0].toLowerCase(Locale.ENGLISH));
        for (int i = 1; i < parts.length; ++i) {
            sb.append(parts[i].substring(0, 1).toUpperCase());
            sb.append(parts[i].substring(1).toLowerCase(Locale.ENGLISH));
        }
        return sb.toString();
    }

    public static String toUpperCamelCase(String value) {
        if ("".equals(value)) {
            return "";
        }
        String newValue = Utils.toCamelCase(value);
        StringBuilder sb = new StringBuilder();
        sb.append(newValue.substring(0, 1).toUpperCase());
        sb.append(newValue.substring(1));
        return sb.toString();
    }

    public static String insertCssClass(String markup, String className) {
        Matcher firstMatcher = firstTagPattern.matcher(markup);
        Matcher othersMatcher = otherTagsPattern.matcher(markup);
        if (!firstMatcher.find() || !othersMatcher.find()) {
            return markup;
        }
        String inBrackets = firstMatcher.group(1);
        Matcher classAttrMatcher = classAttrPattern.matcher(inBrackets);
        StringBuilder classAttributes = new StringBuilder();
        if (classAttrMatcher.find()) {
            classAttributes.append(classAttrMatcher.group(1));
            if (!classAttributes.toString().endsWith(" ")) {
                classAttributes.append(' ');
            }
        }
        classAttributes.append(className);
        if (classAttributes.length() == 0) {
            return markup;
        }
        if ((inBrackets = inBrackets.replaceAll(classAttrPattern.toString(), "")).endsWith("/")) {
            return String.format("<%s class=\"%s\" />%s", inBrackets.replaceAll("/$", "").trim(), classAttributes.toString(), othersMatcher.group(1));
        }
        return String.format("<%s class=\"%s\">%s", inBrackets, classAttributes.toString(), othersMatcher.group(1));
    }

    public static String computeCssClassName(Format style) {
        return String.format("%s%s", CLASS_ATTR_PREFIX, style.getUid());
    }

    public static String styleToCss(Style style, Collection<String> viewNames, boolean resolvePresets, boolean ignoreViewName, boolean ignoreClassName, boolean indent) {
        String themeName = null;
        if (style.isNamed()) {
            themeName = Manager.getThemeManager().getThemeNameOfNamedObject((Identifiable)style);
        } else {
            ThemeElement theme = ThemeManager.getThemeOfFormat((Format)style);
            if (theme != null) {
                themeName = theme.getName();
            }
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder pSb = new StringBuilder();
        for (String viewName : viewNames) {
            String className = Utils.computeCssClassName((Format)style);
            pSb.setLength(0);
            boolean addSpace = false;
            if (!ignoreClassName) {
                pSb.append('.').append(className);
                addSpace = true;
            }
            if (!ignoreViewName && !"*".equals(viewName)) {
                pSb.append(Utils.toUpperCamelCase(viewName));
                addSpace = true;
            }
            for (String path : style.getPathsForView(viewName)) {
                Properties styleProperties = style.getPropertiesFor(viewName, path);
                if (styleProperties.isEmpty()) continue;
                String[] splitPaths = path.split(",");
                int len = splitPaths.length;
                for (int i = 0; i < len; ++i) {
                    sb.append((CharSequence)pSb);
                    if (addSpace && !"".equals(path)) {
                        sb.append(' ');
                    }
                    sb.append(splitPaths[i].trim());
                    if (i >= len - 1) continue;
                    sb.append(", ");
                }
                sb.append(" {");
                if (indent) {
                    sb.append('\n');
                }
                Enumeration<?> propertyNames = cssProperties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    String value = styleProperties.getProperty(propertyName);
                    if (value == null) continue;
                    if (indent) {
                        sb.append("  ");
                    }
                    sb.append(propertyName);
                    sb.append(':');
                    if (indent) {
                        sb.append(' ');
                    }
                    if (resolvePresets) {
                        PresetType preset = null;
                        String presetName = PresetManager.extractPresetName((String)themeName, (String)value);
                        if (presetName != null) {
                            preset = PresetManager.getPresetByName((String)presetName);
                        }
                        if (preset != null) {
                            value = preset.getValue();
                        }
                    }
                    sb.append(value).append(';');
                    if (!indent) continue;
                    sb.append('\n');
                }
                sb.append("}\n");
                if (!indent) continue;
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static void loadCss(Style style, String cssSource, String viewName) {
        Matcher matcher = emptyCssSelectorPattern.matcher(cssSource);
        StringBuilder buf = new StringBuilder();
        while (matcher.find()) {
            if (matcher.group(1).trim().equals("")) {
                buf.append(EMPTY_CSS_SELECTOR);
            }
            buf.append(matcher.group(0));
        }
        cssSource = buf.toString();
        CSSOMParser parser = new CSSOMParser();
        InputSource is = new InputSource((Reader)new StringReader(cssSource));
        CSSStyleSheet css = null;
        try {
            css = parser.parseStyleSheet(is);
        }
        catch (CSSException e) {
            log.error((Object)("Invalid CSS: \n" + cssSource));
        }
        catch (IOException e) {
            log.error((Object)("Could not parse CSS: \n" + cssSource));
        }
        if (css == null) {
            return;
        }
        style.clearPropertiesFor(viewName);
        CSSRuleList rules = css.getCssRules();
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            if (rule.getType() != 1) continue;
            CSSStyleRule sr = (CSSStyleRule)rule;
            CSSStyleDeclaration s = sr.getStyle();
            Properties properties = new Properties();
            for (int j = 0; j < s.getLength(); ++j) {
                String propertyName = s.item(j);
                CSSValue value = s.getPropertyCSSValue(propertyName);
                properties.setProperty(propertyName, value.toString());
            }
            String selector = sr.getSelectorText();
            if (selector.equals(EMPTY_CSS_SELECTOR)) {
                selector = "";
            }
            style.setPropertiesFor(viewName, selector, properties);
        }
    }

    public static List<String> extractCssColors(String value) {
        ArrayList<String> colors = new ArrayList<String>();
        Matcher m = hexColorPattern.matcher(value);
        while (m.find()) {
            colors.add("#" + Utils.optimizeHexColor(m.group(1)));
        }
        m = rgbColorPattern.matcher(value);
        while (m.find()) {
            colors.add("#" + Utils.optimizeHexColor(Utils.rgbToHex(m.group(1))));
        }
        return colors;
    }

    public static String replaceColor(String text, String before, String after) {
        String found;
        Matcher m = hexColorPattern.matcher(text);
        while (m.find()) {
            found = "#" + Utils.optimizeHexColor(m.group(1));
            if (!found.equals(before)) continue;
            text = text.replace(String.format("#%s", m.group(1)), after);
        }
        m = rgbColorPattern.matcher(text);
        while (m.find()) {
            found = "#" + Utils.optimizeHexColor(Utils.rgbToHex(m.group(1)));
            if (!found.equals(before)) continue;
            text = text.replace(String.format("rgb(%s)", m.group(1)), after);
        }
        return text;
    }

    public static String optimizeHexColor(String value) {
        if ((value = value.toLowerCase()).length() != 6) {
            return value;
        }
        if (value.charAt(0) == value.charAt(1) && value.charAt(2) == value.charAt(3) && value.charAt(4) == value.charAt(5)) {
            return String.format("%s%s%s", Character.valueOf(value.charAt(0)), Character.valueOf(value.charAt(2)), Character.valueOf(value.charAt(4)));
        }
        return value;
    }

    public static String rgbToHex(String value) {
        value = value.replaceAll("\\s", "");
        Matcher m = rgbDigitPattern.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String[] rgb = m.group(1).split(",");
            StringBuffer hexcolor = new StringBuffer();
            for (int i = 0; i < rgb.length; ++i) {
                int val = Integer.parseInt(rgb[i]);
                if (val < 16) {
                    hexcolor.append("0");
                }
                hexcolor.append(Integer.toHexString(val));
            }
            m.appendReplacement(sb, hexcolor.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties properties, String resourceName) {
        if (properties.isEmpty()) {
            InputStream in = null;
            try {
                in = Utils.class.getResourceAsStream(resourceName);
                if (in != null) {
                    properties.load(in);
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not load properties", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to close stream", (Throwable)e);
                    }
                }
            }
        }
    }

    public static boolean supportsGzip(HttpServletRequest request) {
        String encoding = request.getHeader("Accept-Encoding");
        return encoding != null && encoding.toLowerCase(Locale.ENGLISH).contains("gzip");
    }

    public static void setCacheHeaders(HttpServletResponse response, CachingDef caching) {
        String lifetime;
        if (caching != null && (lifetime = caching.getLifetime()) != null) {
            long now = System.currentTimeMillis();
            response.addHeader("Cache-Control", "max-age=" + lifetime);
            response.addHeader("Cache-Control", "must-revalidate");
            response.setDateHeader("Last-Modified", now);
            response.setDateHeader("Expires", now + new Long(lifetime) * 1000L);
        }
    }

    static {
        Utils.loadProperties(cssProperties, CSS_PROPERTIES_RESOURCE);
    }
}

