/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.ui;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Head {
    private static final Log log = LogFactory.getLog(Head.class);

    public static String render(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        String themeName = params.get("themeName");
        ThemeElement theme = Manager.getThemeManager().getThemeByName(themeName);
        Widget widget = (Widget)ElementFormatter.getFormatFor((Element)theme, (String)"widget");
        if (widget == null) {
            log.warn((Object)("Theme " + themeName + " has no widget format."));
        } else {
            Properties properties = widget.getProperties();
            String charset = properties.getProperty("charset", "utf-8");
            sb.append(String.format("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=%s\"/>", charset));
            String icon = properties.getProperty("icon", "/favicon.ico");
            sb.append(String.format("<link rel=\"icon\" href=\"%s\" type=\"image/x-icon\"/>", icon));
            sb.append(String.format("<link rel=\"shortcut icon\" href=\"%s\" type=\"image/x-icon\"/>", icon));
        }
        String path = params.get("path");
        sb.append(String.format("<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"/nuxeo/nxthemes-css/?path=%s\"/>", path));
        String baseUrl = params.get("baseUrl");
        if (baseUrl != null) {
            sb.append(String.format("<base href=\"%s\" />", baseUrl));
        }
        return sb.toString();
    }
}

