/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.filters.standalone;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.rendering.StandaloneFilter;

public final class XmlNamespaces
extends StandaloneFilter {
    static final Pattern firstTagPattern = Pattern.compile("<(.*?)>", 32);
    static final Pattern otherTagsPattern = Pattern.compile("<.*?>(.*)", 32);
    static final String xmlnsAttrStr = "xmlns[^\"]+\"([^\"]+)\"";
    static final String spaceXmlnsAttrStr = " xmlns[^\"]+\"([^\"]+)\"";
    static final Pattern xmlnsAttrPattern = Pattern.compile("xmlns[^\"]+\"([^\"]+)\"", 32);

    public RenderingInfo process(RenderingInfo info, boolean cache) {
        String markup = info.getMarkup();
        Matcher attrMatcher = xmlnsAttrPattern.matcher(markup);
        if (!attrMatcher.find()) {
            return info;
        }
        StringBuilder s = new StringBuilder();
        do {
            String attr;
            if (s.indexOf(attr = attrMatcher.group(0)) >= 0) continue;
            s.append(' ');
            s.append(attr);
        } while (attrMatcher.find());
        markup = markup.replaceAll(spaceXmlnsAttrStr, "");
        Matcher firstMatcher = firstTagPattern.matcher(markup);
        Matcher othersMatcher = otherTagsPattern.matcher(markup);
        if (!firstMatcher.find() || !othersMatcher.find()) {
            return info;
        }
        String inBrackets = firstMatcher.group(1);
        String f = String.format("<%s%s>%s", inBrackets, s.toString(), othersMatcher.group(1));
        info.setMarkup(f);
        return info;
    }
}

