/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.ui;

import java.util.Map;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    public static String render(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        String resourcePath = "/nuxeo/nxthemes-lib/";
        String themeUrl = params.get("themeUrl");
        String path = params.get("path");
        ResourceManager resourceManager = Manager.getResourceManager();
        StringBuilder combinedStyles = new StringBuilder();
        StringBuilder combinedScripts = new StringBuilder();
        combinedStyles.append("/nuxeo/nxthemes-lib/");
        combinedScripts.append("/nuxeo/nxthemes-lib/");
        boolean hasScripts = false;
        boolean hasStyles = false;
        for (String resourceName : resourceManager.getResourcesFor(themeUrl)) {
            if (resourceName.endsWith(".css")) {
                combinedStyles.append(resourceName).append(",");
                hasStyles = true;
                continue;
            }
            if (!resourceName.endsWith(".js")) continue;
            combinedScripts.append(resourceName).append(",");
            hasScripts = true;
        }
        combinedStyles.deleteCharAt(combinedStyles.length() - 1);
        combinedScripts.deleteCharAt(combinedScripts.length() - 1);
        combinedStyles.append("?path=").append(path);
        combinedScripts.append("?path=").append(path);
        if (hasStyles) {
            sb.append(String.format("<link type=\"text/css\" rel=\"stylesheet\" media=\"all\" href=\"%s\"></link>", combinedStyles.toString()));
        }
        if (hasScripts) {
            sb.append(String.format("<script type=\"text/javascript\" src=\"%s\"></script>", combinedScripts.toString()));
        }
        return sb.toString();
    }
}

