/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.html.JSMin;
import org.nuxeo.theme.themes.ThemeException;

public final class JSUtils {
    static final Log log = LogFactory.getLog(JSUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String compressSource(String source) throws ThemeException {
        String compressedSource = source;
        ByteArrayInputStream in = null;
        OutputStream out = null;
        try {
            in = new ByteArrayInputStream(source.getBytes());
            out = new ByteArrayOutputStream();
            JSMin compressor = new JSMin(in, out);
            try {
                compressor.jsmin();
            }
            catch (JSMin.UnterminatedRegExpLiteralException e) {
                throw new ThemeException("Could not compress javascript", (Throwable)e);
            }
            catch (JSMin.UnterminatedCommentException e) {
                throw new ThemeException("Could not compress javascript", (Throwable)e);
            }
            catch (JSMin.UnterminatedStringLiteralException e) {
                throw new ThemeException("Could not compress javascript", (Throwable)e);
            }
            compressedSource = out.toString();
        }
        catch (IOException e) {
            throw new ThemeException("Could not compress javascript", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    try {
                        out.close();
                        out = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        out = null;
                    }
                }
                catch (Throwable throwable) {
                    out = null;
                    throw throwable;
                }
            }
        }
        if (in == null) return compressedSource;
        try {
            try {
                ((InputStream)in).close();
                in = null;
                return compressedSource;
            }
            catch (IOException e) {
                e.printStackTrace();
                return compressedSource;
            }
        }
        finally {
            in = null;
        }
    }
}

