/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.ui;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Utils;
import org.nuxeo.theme.resources.ResourceType;
import org.nuxeo.theme.types.TypeFamily;

public class MVCElement {
    private static final Log log = LogFactory.getLog(MVCElement.class);

    public static String render(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        String resource = params.get("resource");
        String url = params.get("url");
        String body = params.get("body");
        String className = params.get("className");
        sb.append(String.format("<ins class=\"%s\">", className));
        if (null != resource) {
            ResourceType resourceType = (ResourceType)Manager.getTypeRegistry().lookup(TypeFamily.RESOURCE, resource);
            if (resourceType == null) {
                log.warn((Object)("Could not find resource: " + resource));
            } else {
                try {
                    sb.append(Utils.readResourceAsString((String)resourceType.getPath()));
                }
                catch (IOException e) {
                    log.warn((Object)("Could not find resource: " + resource));
                }
            }
        }
        if (null != url) {
            sb.append(String.format(" cite=%s", url));
        }
        if (null != body) {
            sb.append(body);
        }
        sb.append("</ins>");
        return sb.toString();
    }
}

