/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.html.filters.standalone;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.rendering.StandaloneFilter;

public final class XmlNamespaces
extends StandaloneFilter {
    static final Pattern tagsPattern = Pattern.compile("(.*?)<([^/@!<>].*?)>(.*)", 32);
    static final String xmlnsAttrStr = "xmlns[^\"]+\"([^\"]+)\"";
    static final String spaceXmlnsAttrStr = " xmlns[^\"]+\"([^\"]+)\"";
    static final Pattern xmlnsAttrPattern = Pattern.compile("xmlns[^\"]+\"([^\"]+)\"", 32);

    public RenderingInfo process(RenderingInfo info, boolean cache) {
        String markup = info.getMarkup();
        Matcher attrMatcher = xmlnsAttrPattern.matcher(markup);
        if (!attrMatcher.find()) {
            return info;
        }
        StringBuilder s = new StringBuilder();
        do {
            String attr;
            if (s.indexOf(attr = attrMatcher.group(0)) >= 0) continue;
            s.append(' ');
            s.append(attr);
        } while (attrMatcher.find());
        Matcher firstMatcher = tagsPattern.matcher(markup = markup.replaceAll(spaceXmlnsAttrStr, ""));
        if (!firstMatcher.find()) {
            return info;
        }
        String f = String.format("%s<%s%s>%s", firstMatcher.group(1), firstMatcher.group(2), s.toString(), firstMatcher.group(3));
        info.setMarkup(f);
        return info;
    }
}

