/*
 * Decompiled with CFR 0.152.
 */
public class Apdex {
    private static final float DEFAULT_THRESOLD = 1.5f;
    final float threshold;
    int satisfied;
    int tolerating;
    int frustrated;

    Apdex() {
        this.threshold = 1.5f;
    }

    Apdex(Float thresold) {
        this.threshold = thresold == null ? 1.5f : thresold.floatValue();
    }

    public void addMs(long value) {
        this.add((double)value / 1000.0);
    }

    public void add(double value) {
        if (value <= (double)this.threshold) {
            ++this.satisfied;
        } else if (value <= (double)(4.0f * this.threshold)) {
            ++this.tolerating;
        } else {
            ++this.frustrated;
        }
    }

    public float getScore() {
        long total = this.satisfied + this.tolerating + this.frustrated;
        if (total == 0L) {
            return 0.0f;
        }
        return (float)(((double)this.satisfied + (double)this.tolerating / 2.0) / (double)total);
    }

    public Rating getRating() {
        float score = this.getScore();
        if ((double)score < 0.5) {
            return Rating.Unacceptable;
        }
        if ((double)score < 0.7) {
            return Rating.Poor;
        }
        if ((double)score < 0.85) {
            return Rating.Fair;
        }
        if ((double)score < 0.94) {
            return Rating.Good;
        }
        return Rating.Excellent;
    }

    static enum Rating {
        Unacceptable,
        Poor,
        Fair,
        Good,
        Excellent;

    }
}

