/*
 * Decompiled with CFR 0.152.
 */
import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class App
implements Runnable {
    private static final Logger log = Logger.getLogger(App.class);
    private static final String PROGRAM_NAME = "java -jar gatling-report.jar";
    private final Options options = new Options();
    private List<SimulationContext> stats;

    public App(String[] args) {
        JCommander command = new JCommander((Object)this.options, args);
        command.setProgramName(PROGRAM_NAME);
        if (this.options.help) {
            command.usage();
            System.exit(0);
        }
    }

    @Override
    public void run() {
        this.parseSimulationFiles();
        this.render();
    }

    private void parseSimulationFiles() {
        ArrayList files = new ArrayList(this.options.simulations.size());
        this.stats = new ArrayList<SimulationContext>(files.size());
        this.options.simulations.forEach(simulation -> this.parseSimulationFile(new File((String)simulation)));
    }

    private void parseSimulationFile(File file) {
        log.info((Object)("Parsing " + file.getAbsolutePath()));
        try {
            this.stats.add(new SimulationParser(file, this.options.apdexT).parse());
        }
        catch (IOException e) {
            log.error((Object)("Invalid file: " + file.getAbsolutePath()), (Throwable)e);
        }
    }

    private void render() {
        if (this.options.outputDirectory == null) {
            this.renderAsCsv();
        } else {
            try {
                this.renderAsReport();
            }
            catch (IOException e) {
                log.error((Object)"Can not generate report", (Throwable)e);
            }
        }
    }

    private void renderAsReport() throws IOException {
        File dir = new File(this.options.outputDirectory);
        if (!dir.mkdirs()) {
            if (!this.options.force) {
                log.error((Object)"Abort, report directory already exists, use -f to override.");
                System.exit(-2);
            }
            log.warn((Object)("Overriding existing report directory" + this.options.outputDirectory));
        }
        String reportPath = new Report(this.stats).setOutputDirectory(dir).includeJs(this.options.includeJs).setTemplate(this.options.template).includeGraphite(this.options.graphiteUrl, this.options.user, this.options.password, this.options.getZoneId()).yamlReport(this.options.yaml).withMap(this.options.map).setFilename(this.options.outputName).create();
        log.info((Object)("Report generated: " + reportPath));
    }

    private void renderAsCsv() {
        System.out.println(RequestStat.header());
        this.stats.forEach(System.out::println);
    }

    public static void main(String[] args) {
        new Thread(new App(args)).start();
    }
}

