/*
 * Decompiled with CFR 0.152.
 */
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class Report {
    private static final String YAML = "yaml/";
    private static final String HTML = "html/";
    private static final String DEFAULT_FILENAME = "index.html";
    private static final String SIMULATION_TEMPLATE = "simulation.mustache";
    private static final String TREND_TEMPLATE = "trend.mustache";
    private static final String DIFF_TEMPLATE = "diff.mustache";
    private static final String DEFAULT_SCRIPT = "plotly-latest.min.js";
    private static final String DEFAULT_CDN_SCRIPT = "https://cdn.plot.ly/plotly-latest.min.js";
    private final List<SimulationContext> stats;
    private File outputDirectory;
    private Writer writer;
    private List<String> scripts = new ArrayList<String>();
    private boolean includeJs = false;
    private String template;
    private String graphiteUrl;
    private String user;
    private String password;
    private Graphite graphite;
    private ZoneId zoneId;
    private boolean yaml = false;
    private List<String> map;
    private String filename = "index.html";

    public Report(List<SimulationContext> stats) {
        this.stats = stats;
    }

    public Report setOutputDirectory(File output) {
        this.outputDirectory = output;
        return this;
    }

    public Report setWriter(Writer writer) {
        this.writer = writer;
        return this;
    }

    public Report addScript(String script) {
        this.scripts.add(script);
        return this;
    }

    public Report includeJs(boolean value) {
        this.includeJs = value;
        return this;
    }

    public Report setTemplate(String template) {
        this.template = template;
        return this;
    }

    public String create() throws IOException {
        int nbSimulation = this.stats.size();
        if (this.graphiteUrl != null) {
            this.stats.forEach(stats -> {
                stats.simStat.graphite = new Graphite(this.graphiteUrl, this.user, this.password, (SimulationContext)stats, this.outputDirectory, this.zoneId);
            });
        }
        switch (nbSimulation) {
            case 1: {
                this.createSimulationReport();
                break;
            }
            case 2: {
                this.createDiffReport();
                break;
            }
            default: {
                this.createTrendReport();
            }
        }
        return this.getReportPath().getAbsolutePath();
    }

    public void createSimulationReport() throws IOException {
        Mustache mustache = this.getMustache();
        mustache.execute(this.getWriter(), (Object)this.stats.get(0).setScripts(this.getScripts())).flush();
    }

    private Mustache getMustache() throws FileNotFoundException {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = this.template == null ? mf.compile(this.getDefaultTemplate()) : mf.compile((Reader)new FileReader(new File(this.template)), this.template);
        return mustache;
    }

    public void createTrendReport() throws IOException {
        Mustache mustache = this.getMustache();
        if (this.map != null && this.map.size() == this.stats.size()) {
            HashMap<String, Object> scopes = new HashMap<String, Object>();
            scopes.put("trend", new TrendContext(this.stats).setScripts(this.getScripts()));
            int i = 0;
            for (String name : this.map) {
                scopes.put(name, this.stats.get(i++));
            }
            mustache.execute(this.getWriter(), scopes).flush();
        } else {
            mustache.execute(this.getWriter(), (Object)new TrendContext(this.stats).setScripts(this.getScripts())).flush();
        }
    }

    public void createDiffReport() throws IOException {
        Mustache mustache = this.getMustache();
        if (this.map != null && this.map.size() == this.stats.size()) {
            HashMap<String, Object> scopes = new HashMap<String, Object>();
            scopes.put("diff", new DiffContext(this.stats).setScripts(this.getScripts()));
            int i = 0;
            for (String name : this.map) {
                scopes.put(name, this.stats.get(i++));
            }
            mustache.execute(this.getWriter(), scopes).flush();
        } else {
            mustache.execute(this.getWriter(), (Object)new DiffContext(this.stats).setScripts(this.getScripts())).flush();
        }
    }

    public Writer getWriter() throws IOException {
        if (this.writer == null) {
            File index = this.getReportPath();
            this.writer = new FileWriter(index);
        }
        return this.writer;
    }

    public File getReportPath() {
        return new File(this.outputDirectory, this.filename);
    }

    public List<String> getScripts() {
        if (this.scripts.isEmpty()) {
            this.scripts.add(this.getOrCreateDefaultScript());
        }
        return this.scripts;
    }

    public String getOrCreateDefaultScript() {
        if (this.outputDirectory == null || !this.includeJs) {
            return DEFAULT_CDN_SCRIPT;
        }
        URL src = this.getClass().getResource(DEFAULT_SCRIPT);
        try {
            FileUtils.copyURLToFile((URL)src, (File)new File(this.outputDirectory, DEFAULT_SCRIPT));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not copy script: " + src, e);
        }
        return DEFAULT_SCRIPT;
    }

    public String getDefaultTemplate() {
        int nbSimulation = this.stats.size();
        String prefix = this.yaml ? YAML : HTML;
        switch (nbSimulation) {
            case 1: {
                return prefix + SIMULATION_TEMPLATE;
            }
            case 2: {
                return prefix + DIFF_TEMPLATE;
            }
        }
        return prefix + TREND_TEMPLATE;
    }

    public Report includeGraphite(String graphiteUrl, String user, String password, ZoneId zoneId) {
        this.graphiteUrl = graphiteUrl;
        this.user = user;
        this.password = password;
        this.zoneId = zoneId;
        return this;
    }

    public Report yamlReport(boolean yaml) {
        this.yaml = yaml;
        return this;
    }

    public Report withMap(List<String> map) {
        this.map = map;
        return this;
    }

    public Report setFilename(String filename) {
        if (filename != null) {
            this.filename = filename;
        }
        return this;
    }
}

