/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.quux00.simplecsv.CsvParser;
import net.quux00.simplecsv.CsvParserBuilder;
import net.quux00.simplecsv.CsvReader;
import net.quux00.simplecsv.CsvReaderBuilder;

public class SimulationParser {
    private static final String OK = "OK";
    private static final String REQUEST = "REQUEST";
    private static final String RUN = "RUN";
    private static final String USER = "USER";
    private static final String START = "START";
    private static final String END = "END";
    private static final String GZ = "gz";
    private final File file;
    private final Float apdexT;

    public SimulationParser(File file, Float apdexT) {
        this.file = file;
        this.apdexT = apdexT;
    }

    public SimulationParser(File file) {
        this.file = file;
        this.apdexT = null;
    }

    public SimulationContext parse() throws IOException {
        List line;
        SimulationContext ret = new SimulationContext(this.file.getAbsolutePath(), this.apdexT);
        CsvParser p = new CsvParserBuilder().trimWhitespace(true).allowUnbalancedQuotes(true).separator('\t').build();
        CsvReader reader = new CsvReaderBuilder(this.getReaderFor(this.file)).csvParser(p).build();
        while ((line = reader.readNext()) != null) {
            if (line.size() <= 2) {
                this.invalidFile();
            }
            String scenario = (String)line.get(0);
            block5 : switch ((String)line.get(2)) {
                case "RUN": {
                    String version = (String)line.get(5);
                    if (!version.startsWith("2.")) {
                        return this.invalidFile();
                    }
                    ret.setSimulationName((String)line.get(1));
                    ret.setStart(Long.parseLong((String)line.get(3)));
                    break;
                }
                case "REQUEST": {
                    String name = (String)line.get(4);
                    long start = Long.parseLong((String)line.get(6));
                    long end = Long.parseLong((String)line.get(8));
                    boolean success = OK.equals(line.get(9));
                    ret.addRequest(scenario, name, start, end, success);
                    break;
                }
                case "USER": {
                    switch ((String)line.get(3)) {
                        case "START": {
                            ret.addUser(scenario);
                            break block5;
                        }
                        case "END": {
                            ret.endUser(scenario);
                        }
                    }
                }
            }
        }
        ret.computeStat();
        return ret;
    }

    private SimulationContext invalidFile() {
        throw new IllegalArgumentException(String.format("Invalid simulation file: %s expecting Gatling 2.x format", this.file.getAbsolutePath()));
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        try {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    private Reader getReaderFor(File file) throws IOException {
        if (GZ.equals(this.getFileExtension(file))) {
            FileInputStream fileStream = new FileInputStream(file);
            GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
            return new InputStreamReader((InputStream)gzipStream, "UTF-8");
        }
        return new FileReader(file);
    }
}

