/*
 * Decompiled with CFR 0.152.
 */
import capsule.DependencyManager;
import capsule.PomReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Capsule
implements Runnable {
    private static final String VERSION = "0.5.0";
    private static final String PROP_RESET = "capsule.reset";
    private static final String PROP_VERSION = "capsule.version";
    private static final String PROP_LOG = "capsule.log";
    private static final String PROP_TREE = "capsule.tree";
    private static final String PROP_APP_ID = "capsule.app.id";
    private static final String PROP_PRINT_JRES = "capsule.jvms";
    private static final String PROP_CAPSULE_JAVA_HOME = "capsule.java.home";
    private static final String PROP_MODE = "capsule.mode";
    private static final String PROP_USE_LOCAL_REPO = "capsule.local";
    private static final String PROP_OFFLINE = "capsule.offline";
    private static final String PROP_RESOLVE = "capsule.resolve";
    private static final String PROP_JAVA_VERSION = "java.version";
    private static final String PROP_JAVA_HOME = "java.home";
    private static final String PROP_OS_NAME = "os.name";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_JAVA_LIBRARY_PATH = "java.library.path";
    private static final String PROP_FILE_SEPARATOR = "file.separator";
    private static final String PROP_PATH_SEPARATOR = "path.separator";
    private static final String PROP_JAVA_SECURITY_POLICY = "java.security.policy";
    private static final String PROP_JAVA_SECURITY_MANAGER = "java.security.manager";
    private static final String ENV_CAPSULE_REPOS = "CAPSULE_REPOS";
    private static final String ATTR_APP_NAME = "Application-Name";
    private static final String ATTR_APP_VERSION = "Application-Version";
    private static final String ATTR_APP_CLASS = "Application-Class";
    private static final String ATTR_APP_ARTIFACT = "Application";
    private static final String ATTR_UNIX_SCRIPT = "Unix-Script";
    private static final String ATTR_WINDOWS_SCRIPT = "Windows-Script";
    private static final String ATTR_EXTRACT = "Extract-Capsule";
    private static final String ATTR_MIN_JAVA_VERSION = "Min-Java-Version";
    private static final String ATTR_JAVA_VERSION = "Java-Version";
    private static final String ATTR_JDK_REQUIRED = "JDK-Required";
    private static final String ATTR_JVM_ARGS = "JVM-Args";
    private static final String ATTR_ARGS = "Args";
    private static final String ATTR_ENV = "Environment-Variables";
    private static final String ATTR_SYSTEM_PROPERTIES = "System-Properties";
    private static final String ATTR_APP_CLASS_PATH = "App-Class-Path";
    private static final String ATTR_CAPSULE_IN_CLASS_PATH = "Capsule-In-Class-Path";
    private static final String ATTR_BOOT_CLASS_PATH = "Boot-Class-Path";
    private static final String ATTR_BOOT_CLASS_PATH_A = "Boot-Class-Path-A";
    private static final String ATTR_BOOT_CLASS_PATH_P = "Boot-Class-Path-P";
    private static final String ATTR_LIBRARY_PATH_A = "Library-Path-A";
    private static final String ATTR_LIBRARY_PATH_P = "Library-Path-P";
    private static final String ATTR_SECURITY_MANAGER = "Security-Manager";
    private static final String ATTR_SECURITY_POLICY = "Security-Policy";
    private static final String ATTR_SECURITY_POLICY_A = "Security-Policy-A";
    private static final String ATTR_JAVA_AGENTS = "Java-Agents";
    private static final String ATTR_REPOSITORIES = "Repositories";
    private static final String ATTR_DEPENDENCIES = "Dependencies";
    private static final String ATTR_NATIVE_DEPENDENCIES_LINUX = "Native-Dependencies-Linux";
    private static final String ATTR_NATIVE_DEPENDENCIES_WIN = "Native-Dependencies-Win";
    private static final String ATTR_NATIVE_DEPENDENCIES_MAC = "Native-Dependencies-Mac";
    private static final String ATTR_IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String VAR_CAPSULE_DIR = "CAPSULE_DIR";
    private static final String VAR_CAPSULE_JAR = "CAPSULE_JAR";
    private static final String VAR_JAVA_HOME = "JAVA_HOME";
    private static final String ENV_CACHE_DIR = "CAPSULE_CACHE_DIR";
    private static final String ENV_CACHE_NAME = "CAPSULE_CACHE_NAME";
    private static final String PROP_CAPSULE_JAR = "capsule.jar";
    private static final String PROP_CAPSULE_DIR = "capsule.dir";
    private static final String PROP_CAPSULE_APP = "capsule.app";
    private static final String CACHE_DEFAULT_NAME = "capsule";
    private static final String DEPS_CACHE_NAME = "deps";
    private static final String APP_CACHE_NAME = "apps";
    private static final String POM_FILE = "pom.xml";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final Path DEFAULT_LOCAL_MAVEN = Paths.get(System.getProperty("user.home"), ".m2", "repository");
    private static final boolean debug = "debug".equals(System.getProperty("capsule.log", "quiet"));
    private static final boolean verbose = debug || "verbose".equals(System.getProperty("capsule.log", "quiet"));
    private static final Path cacheDir = Capsule.getCacheDir();
    private final JarFile jar;
    private final Manifest manifest;
    private final String javaHome;
    private final String appId;
    private final Path appCache;
    private final boolean cacheUpToDate;
    private final String mode;
    private final Object pom;
    private final Object dependencyManager;
    private Process child;
    private static final Pattern PAT_JAVA_VERSION = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<patch>\\d+)(_(?<update>\\d+))?(-(?<pre>[^-]+))?(-(?<build>.+))?");

    public static void main(String[] args) {
        try {
            Capsule capsule = Capsule.newCapsule(Capsule.getJarFile(), args);
            if (Capsule.anyPropertyDefined(PROP_VERSION, PROP_PRINT_JRES, PROP_TREE, PROP_RESOLVE)) {
                if (Capsule.anyPropertyDefined(PROP_VERSION)) {
                    capsule.printVersion();
                }
                if (Capsule.anyPropertyDefined(PROP_PRINT_JRES)) {
                    capsule.printJVMs();
                }
                if (Capsule.anyPropertyDefined(PROP_TREE)) {
                    capsule.printDependencyTree(args);
                }
                if (Capsule.anyPropertyDefined(PROP_RESOLVE)) {
                    capsule.resolve(args);
                }
                return;
            }
            capsule.launch(args);
        }
        catch (Throwable t) {
            System.err.println("CAPSULE EXCEPTION: " + t.getMessage() + (!verbose ? " (for stack trace, run with -Dcapsule.log=verbose)" : ""));
            if (verbose) {
                t.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static Capsule newCapsule(JarFile jar, String[] args) {
        try {
            Class<?> clazz = Class.forName("CustomCapsule");
            try {
                Constructor<?> ctor = clazz.getConstructor(JarFile.class, String[].class);
                ctor.setAccessible(true);
                return (Capsule)ctor.newInstance(jar, args);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not launch custom capsule.", e);
            }
        }
        catch (ClassNotFoundException e) {
            return new Capsule(jar, args);
        }
    }

    protected Capsule(JarFile jar, String[] args) {
        this.jar = jar;
        try {
            this.manifest = jar.getManifest();
            if (this.manifest == null) {
                throw new RuntimeException("Jar file " + jar.getName() + " does not have a manifest");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read Jar file " + jar.getName() + " manifest");
        }
        this.javaHome = this.getJavaHome();
        this.mode = System.getProperty(PROP_MODE);
        this.pom = !this.hasAttribute(ATTR_DEPENDENCIES) && this.hasPom() ? this.createPomReader() : null;
        this.dependencyManager = this.needsDependencyManager() ? this.createDependencyManager(this.getRepositories()) : null;
        this.appId = this.getAppId(args);
        this.appCache = this.needsAppCache() ? this.getAppCacheDir() : null;
        this.cacheUpToDate = this.appCache != null ? this.isUpToDate() : false;
    }

    private boolean needsDependencyManager() {
        return this.hasAttribute(ATTR_APP_ARTIFACT) || this.isEmptyCapsule() || this.pom != null || this.getDependencies() != null || this.getNativeDependencies() != null;
    }

    private void launch(String[] args) throws IOException, InterruptedException {
        if (this.launchCapsule(args)) {
            return;
        }
        Capsule.verbose("Launching app " + this.appId);
        this.ensureExtractedIfNecessary();
        ProcessBuilder pb = this.buildProcess(args);
        if (this.appCache != null && !this.cacheUpToDate) {
            this.markCache();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this));
        if (!Capsule.isInheritIoBug()) {
            pb.inheritIO();
        }
        this.child = pb.start();
        if (Capsule.isInheritIoBug()) {
            this.pipeIoStreams();
        }
        System.exit(this.child.waitFor());
    }

    private void printVersion() {
        System.out.println("CAPSULE: Application " + this.appId);
        System.out.println("CAPSULE: Capsule Version 0.5.0");
    }

    private void printJVMs() {
        Map<String, Path> jres = Capsule.getJavaHomes(false);
        if (jres == null) {
            Capsule.println("No detected Java installations");
        } else {
            System.out.println("CAPSULE: Detected Java installations:");
            for (Map.Entry<String, Path> j : jres.entrySet()) {
                System.out.println(j.getKey() + (j.getKey().length() < 8 ? "\t\t" : "\t") + j.getValue());
            }
        }
        System.out.println("CAPSULE: selected " + this.javaHome);
    }

    private void resolve(String[] args) throws IOException, InterruptedException {
        this.ensureExtractedIfNecessary();
        this.getPath(this.getListAttribute(ATTR_BOOT_CLASS_PATH));
        this.getPath(this.getListAttribute(ATTR_BOOT_CLASS_PATH_P));
        this.getPath(this.getListAttribute(ATTR_BOOT_CLASS_PATH_A));
        this.resolveAppArtifact(this.getAppArtifact(args));
        this.resolveDependencies(this.getDependencies(), "jar");
        this.resolveNativeDependencies();
    }

    private void ensureExtractedIfNecessary() {
        if (this.appCache != null && !this.cacheUpToDate) {
            this.resetAppCache();
            if (this.shouldExtract()) {
                this.extractCapsule();
            }
        }
    }

    private static boolean isInheritIoBug() {
        return Capsule.isWindows() && Capsule.compareVersions(System.getProperty(PROP_JAVA_VERSION), "1.8.0") < 0;
    }

    private void pipeIoStreams() {
        new Thread((Runnable)this, "pipe-out").start();
        new Thread((Runnable)this, "pipe-err").start();
        new Thread((Runnable)this, "pipe-in").start();
    }

    @Override
    public void run() {
        if (Capsule.isInheritIoBug()) {
            switch (Thread.currentThread().getName()) {
                case "pipe-out": {
                    Capsule.pipe(this.child.getInputStream(), System.out);
                    return;
                }
                case "pipe-err": {
                    Capsule.pipe(this.child.getErrorStream(), System.err);
                    return;
                }
                case "pipe-in": {
                    Capsule.pipe(System.in, this.child.getOutputStream());
                    return;
                }
            }
        }
        if (this.child != null) {
            this.child.destroy();
        }
    }

    private static void pipe(InputStream in, OutputStream out) {
        block15: {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(in));){
                String line;
                PrintStream p = new PrintStream(out);
                while ((line = r.readLine()) != null) {
                    p.println(line);
                }
            }
            catch (IOException e) {
                if (!verbose) break block15;
                e.printStackTrace(System.err);
            }
        }
    }

    private boolean isEmptyCapsule() {
        return !this.hasAttribute(ATTR_APP_ARTIFACT) && !this.hasAttribute(ATTR_APP_CLASS) && this.getScript() == null;
    }

    private void printDependencyTree(String[] args) {
        System.out.println("Dependencies for " + this.appId);
        if (this.dependencyManager == null) {
            System.out.println("No dependencies declared.");
        } else if (this.hasAttribute(ATTR_APP_ARTIFACT) || this.isEmptyCapsule()) {
            String appArtifact;
            String string = appArtifact = this.isEmptyCapsule() ? this.getCommandLineArtifact(args) : this.getAttribute(ATTR_APP_ARTIFACT);
            if (appArtifact == null) {
                throw new IllegalStateException("capsule " + this.jar.getName() + " has nothing to run");
            }
            this.printDependencyTree(appArtifact);
        } else {
            this.printDependencyTree(this.getDependencies(), "jar");
        }
        List<String> nativeDeps = this.getNativeDependencies();
        if (nativeDeps != null) {
            System.out.println("\nNative Dependencies:");
            this.printDependencyTree(nativeDeps, this.getNativeLibExtension());
        }
    }

    private boolean launchCapsule(String[] args) {
        String appArtifact;
        if (this.getScript() == null && (appArtifact = this.getAppArtifact(args)) != null) {
            try {
                List<Path> jars = this.resolveAppArtifact(appArtifact);
                if (jars == null) {
                    return false;
                }
                if (Capsule.isCapsule(jars.get(0))) {
                    Capsule.verbose("Running capsule " + jars.get(0));
                    Capsule.runCapsule(jars.get(0), this.isEmptyCapsule() ? Arrays.copyOfRange(args, 1, args.length) : this.buildArgs(args).toArray(new String[0]));
                    return true;
                }
                if (this.isEmptyCapsule()) {
                    throw new IllegalArgumentException("Artifact " + appArtifact + " is not a capsule.");
                }
            }
            catch (RuntimeException e) {
                if (this.isEmptyCapsule()) {
                    throw new RuntimeException("Usage: java -jar capsule.jar CAPSULE_ARTIFACT_COORDINATES", e);
                }
                throw e;
            }
        }
        return false;
    }

    private String getAppArtifact(String[] args) {
        String appArtifact = null;
        if (this.isEmptyCapsule() && (appArtifact = this.getCommandLineArtifact(args)) == null) {
            throw new IllegalStateException("capsule " + this.jar.getName() + " has nothing to run");
        }
        if (appArtifact == null) {
            appArtifact = this.getAttribute(ATTR_APP_ARTIFACT);
        }
        return appArtifact;
    }

    private String getCommandLineArtifact(String[] args) {
        if (args.length > 0) {
            return args[0];
        }
        return null;
    }

    private ProcessBuilder buildProcess(String[] args) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (!this.buildScriptProcess(pb)) {
            this.buildJavaProcess(pb);
        }
        List<String> command = pb.command();
        command.addAll(this.buildArgs(args));
        this.buildEnvironmentVariables(pb.environment());
        Capsule.verbose(Capsule.join(command, " "));
        return pb;
    }

    protected List<String> buildArgs(String[] args) {
        ArrayList<String> args0 = new ArrayList<String>();
        args0.addAll(Capsule.nullToEmpty(this.expand(this.getListAttribute(ATTR_ARGS))));
        args0.addAll(Arrays.asList(args));
        return args0;
    }

    private boolean buildJavaProcess(ProcessBuilder pb) {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        List<String> cmdLine = runtimeBean.getInputArguments();
        if (this.javaHome != null) {
            pb.environment().put(VAR_JAVA_HOME, this.javaHome);
        }
        List<String> command = pb.command();
        command.add(this.getJavaProcessName(this.javaHome));
        command.addAll(this.buildJVMArgs(cmdLine));
        command.addAll(Capsule.compileSystemProperties(this.buildSystemProperties(cmdLine)));
        Capsule.addOption(command, "-Xbootclasspath:", Capsule.compileClassPath(this.buildBootClassPath(cmdLine)));
        Capsule.addOption(command, "-Xbootclasspath/p:", Capsule.compileClassPath(this.buildClassPath(ATTR_BOOT_CLASS_PATH_P)));
        Capsule.addOption(command, "-Xbootclasspath/a:", Capsule.compileClassPath(this.buildClassPath(ATTR_BOOT_CLASS_PATH_A)));
        List<Path> classPath = this.buildClassPath();
        command.add("-classpath");
        command.add(Capsule.compileClassPath(classPath));
        for (String jagent : Capsule.nullToEmpty(this.buildJavaAgents())) {
            command.add("-javaagent:" + jagent);
        }
        command.add(this.getMainClass(classPath));
        return true;
    }

    private String getScript() {
        return this.getAttribute(Capsule.isWindows() ? ATTR_WINDOWS_SCRIPT : ATTR_UNIX_SCRIPT);
    }

    private boolean buildScriptProcess(ProcessBuilder pb) {
        String script = this.getScript();
        if (script == null) {
            return false;
        }
        if (this.appCache == null) {
            throw new IllegalStateException("Cannot run the startup script " + script + " when the " + ATTR_EXTRACT + " attribute is set to false");
        }
        Path scriptPath = this.appCache.resolve(Capsule.sanitize(script)).toAbsolutePath();
        Capsule.ensureExecutable(scriptPath);
        pb.command().add(scriptPath.toString());
        return true;
    }

    private static void ensureExecutable(Path file) {
        if (!Files.isExecutable(file)) {
            try {
                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(file, new LinkOption[0]);
                if (!perms.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                    EnumSet<PosixFilePermission> newPerms = EnumSet.copyOf(perms);
                    newPerms.add(PosixFilePermission.OWNER_EXECUTE);
                    Files.setPosixFilePermissions(file, newPerms);
                }
            }
            catch (UnsupportedOperationException e) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void addOption(List<String> cmdLine, String prefix, String value) {
        if (value == null) {
            return;
        }
        cmdLine.add(prefix + value);
    }

    private static String compileClassPath(List<Path> cp) {
        return Capsule.join(cp, PATH_SEPARATOR);
    }

    private List<Path> buildClassPath() {
        ArrayList<Path> classPath = new ArrayList<Path>();
        if (!this.isEmptyCapsule() && !this.hasAttribute(ATTR_APP_ARTIFACT)) {
            String isCapsuleInClassPath = this.getAttribute(ATTR_CAPSULE_IN_CLASS_PATH);
            if (isCapsuleInClassPath == null || Boolean.parseBoolean(isCapsuleInClassPath)) {
                classPath.add(Paths.get(this.jar.getName(), new String[0]));
            } else if (this.appCache == null) {
                throw new IllegalStateException("Cannot set the Capsule-In-Class-Path attribute to false when the Extract-Capsule attribute is also set to false");
            }
        }
        if (this.hasAttribute(ATTR_APP_ARTIFACT)) {
            assert (this.dependencyManager != null);
            classPath.addAll(Capsule.nullToEmpty(this.resolveAppArtifact(this.getAttribute(ATTR_APP_ARTIFACT))));
        }
        if (this.hasAttribute(ATTR_APP_CLASS_PATH)) {
            for (String sp : this.getListAttribute(ATTR_APP_CLASS_PATH)) {
                Path p = Paths.get(this.expand(Capsule.sanitize(sp)), new String[0]);
                if (this.appCache == null && (!p.isAbsolute() || p.startsWith(this.appCache))) {
                    throw new IllegalStateException("Cannot resolve " + sp + "  in " + ATTR_APP_CLASS_PATH + " attribute when the " + ATTR_EXTRACT + " attribute is set to false");
                }
                p = this.appCache.resolve(p);
                classPath.add(p);
            }
        }
        if (this.appCache != null) {
            classPath.addAll(Capsule.nullToEmpty(this.getDefaultCacheClassPath()));
        }
        classPath.addAll(Capsule.nullToEmpty(this.resolveDependencies(this.getDependencies(), "jar")));
        return classPath;
    }

    private List<Path> buildBootClassPath(List<String> cmdLine) {
        String option = null;
        for (String o : cmdLine) {
            if (!o.startsWith("-Xbootclasspath:")) continue;
            option = o.substring("-Xbootclasspath:".length());
        }
        if (option != null) {
            return Capsule.toPath(Arrays.asList(option.split(PATH_SEPARATOR)));
        }
        return this.getPath(this.getListAttribute(ATTR_BOOT_CLASS_PATH));
    }

    private List<Path> buildClassPath(String attr) {
        return this.getPath(this.getListAttribute(attr));
    }

    private void buildEnvironmentVariables(Map<String, String> env) {
        List<String> jarEnv = this.getListAttribute(ATTR_ENV);
        if (jarEnv != null) {
            for (String e : jarEnv) {
                String var = Capsule.getBefore(e, '=');
                String value = Capsule.getAfter(e, '=');
                if (var == null) {
                    throw new IllegalArgumentException("Malformed env variable definition: " + e);
                }
                boolean overwrite = false;
                if (var.endsWith(":")) {
                    overwrite = true;
                    var = var.substring(0, var.length() - 1);
                }
                if (!overwrite && env.containsKey(var)) continue;
                env.put(var, value != null ? value : "");
            }
        }
    }

    protected Map<String, String> buildSystemProperties(List<String> cmdLine) {
        HashMap<String, String> systemProerties = new HashMap<String, String>();
        for (String p : Capsule.nullToEmpty(this.getListAttribute(ATTR_SYSTEM_PROPERTIES))) {
            if (p.trim().isEmpty()) continue;
            this.addSystemProperty(p, systemProerties);
        }
        if (this.appCache != null) {
            List<Path> libraryPath = this.buildNativeLibraryPath();
            libraryPath.add(this.appCache);
            systemProerties.put(PROP_JAVA_LIBRARY_PATH, Capsule.compileClassPath(libraryPath));
        } else if (this.hasAttribute(ATTR_LIBRARY_PATH_P) || this.hasAttribute(ATTR_LIBRARY_PATH_A)) {
            throw new IllegalStateException("Cannot use the Library-Path-P or the Library-Path-A attributes when the Extract-Capsule attribute is set to false");
        }
        if (this.hasAttribute(ATTR_SECURITY_POLICY) || this.hasAttribute(ATTR_SECURITY_POLICY_A)) {
            systemProerties.put(PROP_JAVA_SECURITY_MANAGER, "");
            if (this.hasAttribute(ATTR_SECURITY_POLICY_A)) {
                systemProerties.put(PROP_JAVA_SECURITY_POLICY, this.toJarUrl(this.getAttribute(ATTR_SECURITY_POLICY_A)));
            }
            if (this.hasAttribute(ATTR_SECURITY_POLICY)) {
                systemProerties.put(PROP_JAVA_SECURITY_POLICY, "=" + this.toJarUrl(this.getAttribute(ATTR_SECURITY_POLICY)));
            }
        }
        if (this.hasAttribute(ATTR_SECURITY_MANAGER)) {
            systemProerties.put(PROP_JAVA_SECURITY_MANAGER, this.getAttribute(ATTR_SECURITY_MANAGER));
        }
        if (this.appCache != null) {
            systemProerties.put(PROP_CAPSULE_DIR, this.appCache.toAbsolutePath().toString());
        }
        systemProerties.put(PROP_CAPSULE_JAR, this.getJarPath());
        systemProerties.put(PROP_CAPSULE_APP, this.appId);
        for (String option : cmdLine) {
            if (!option.startsWith("-D")) continue;
            Capsule.addSystemProperty0(option.substring(2), systemProerties);
        }
        return systemProerties;
    }

    private List<Path> buildNativeLibraryPath() {
        ArrayList<Path> libraryPath = new ArrayList<Path>();
        this.resolveNativeDependencies();
        libraryPath.addAll(Capsule.nullToEmpty(Capsule.toAbsolutePath(this.appCache, this.getListAttribute(ATTR_LIBRARY_PATH_P))));
        libraryPath.addAll(Capsule.toPath(Arrays.asList(ManagementFactory.getRuntimeMXBean().getLibraryPath().split(PATH_SEPARATOR))));
        libraryPath.addAll(Capsule.nullToEmpty(Capsule.toAbsolutePath(this.appCache, this.getListAttribute(ATTR_LIBRARY_PATH_A))));
        libraryPath.add(this.appCache);
        return libraryPath;
    }

    private String getNativeLibExtension() {
        if (Capsule.isLinux()) {
            return "so";
        }
        if (Capsule.isWindows()) {
            return "dll";
        }
        if (Capsule.isMac()) {
            return "dylib";
        }
        throw new RuntimeException("Unsupported operating system: " + System.getProperty(PROP_OS_NAME));
    }

    private List<String> getNativeDependencies() {
        return this.stripNativeDependencies(this.getNativeDependenciesAndRename());
    }

    protected List<String> getNativeDependenciesAndRename() {
        if (Capsule.isLinux()) {
            return this.getListAttribute(ATTR_NATIVE_DEPENDENCIES_LINUX);
        }
        if (Capsule.isWindows()) {
            return this.getListAttribute(ATTR_NATIVE_DEPENDENCIES_WIN);
        }
        if (Capsule.isMac()) {
            return this.getListAttribute(ATTR_NATIVE_DEPENDENCIES_MAC);
        }
        return null;
    }

    protected final List<String> stripNativeDependencies(List<String> nativeDepsAndRename) {
        if (nativeDepsAndRename == null) {
            return null;
        }
        ArrayList<String> deps = new ArrayList<String>(nativeDepsAndRename.size());
        for (String depAndRename : nativeDepsAndRename) {
            String[] dna = depAndRename.split(",");
            deps.add(dna[0]);
        }
        return deps;
    }

    private boolean hasRenamedNativeDependencies() {
        List<String> depsAndRename = this.getNativeDependenciesAndRename();
        if (depsAndRename == null) {
            return false;
        }
        for (String depAndRename : depsAndRename) {
            if (!depAndRename.contains(",")) continue;
            return true;
        }
        return false;
    }

    private void resolveNativeDependencies() {
        if (this.appCache == null) {
            throw new IllegalStateException("Cannot set Extract-Capsule to false if there are native dependencies.");
        }
        List<String> depsAndRename = this.getNativeDependenciesAndRename();
        if (depsAndRename == null || depsAndRename.isEmpty()) {
            return;
        }
        ArrayList<String> deps = new ArrayList<String>(depsAndRename.size());
        ArrayList<String> renames = new ArrayList<String>(depsAndRename.size());
        for (String depAndRename : depsAndRename) {
            String[] dna = depAndRename.split(",");
            deps.add(dna[0]);
            renames.add(dna.length > 1 ? dna[1] : null);
        }
        Capsule.verbose("Resolving native libs " + deps);
        List<Path> resolved = this.resolveDependencies(deps, this.getNativeLibExtension());
        if (resolved.size() != deps.size()) {
            throw new RuntimeException("One of the native artifacts " + deps + " reolved to more than a single file");
        }
        assert (this.appCache != null);
        if (!this.cacheUpToDate) {
            if (debug) {
                System.err.println("Copying native libs to " + this.appCache);
            }
            try {
                for (int i = 0; i < deps.size(); ++i) {
                    Path lib = resolved.get(i);
                    String rename = Capsule.sanitize((String)renames.get(i));
                    Files.copy(lib, this.appCache.resolve(rename != null ? rename : lib.getFileName().toString()), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while copying native libs");
            }
        }
    }

    private String getJarPath() {
        return Paths.get(this.jar.getName(), new String[0]).getParent().toAbsolutePath().toString();
    }

    private static List<String> compileSystemProperties(Map<String, String> ps) {
        ArrayList<String> command = new ArrayList<String>();
        for (Map.Entry<String, String> entry : ps.entrySet()) {
            command.add("-D" + entry.getKey() + (entry.getValue() != null && !entry.getValue().isEmpty() ? "=" + entry.getValue() : ""));
        }
        return command;
    }

    private void addSystemProperty(String p, Map<String, String> ps) {
        try {
            String name = Capsule.getBefore(p, '=');
            String value = Capsule.getAfter(p, '=');
            ps.put(name, value != null ? this.expand(value) : "");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal system property definition: " + p);
        }
    }

    private static void addSystemProperty0(String p, Map<String, String> ps) {
        try {
            String name = Capsule.getBefore(p, '=');
            String value = Capsule.getAfter(p, '=');
            ps.put(name, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal system property definition: " + p);
        }
    }

    protected List<String> buildJVMArgs(List<String> cmdLine) {
        LinkedHashMap<String, String> jvmArgs = new LinkedHashMap<String, String>();
        for (String a : Capsule.nullToEmpty(this.getListAttribute(ATTR_JVM_ARGS))) {
            if ((a = a.trim()).isEmpty() || a.startsWith("-Xbootclasspath:") || a.startsWith("-javaagent:")) continue;
            Capsule.addJvmArg(this.expand(a), jvmArgs);
        }
        for (String option : cmdLine) {
            if (option.startsWith("-D") || option.startsWith("-Xbootclasspath:")) continue;
            Capsule.addJvmArg(option, jvmArgs);
        }
        return new ArrayList<String>(jvmArgs.values());
    }

    private static void addJvmArg(String a, Map<String, String> args) {
        args.put(Capsule.getJvmArgKey(a), a);
    }

    private static String getJvmArgKey(String a) {
        if (a.equals("-client") || a.equals("-server")) {
            return "compiler";
        }
        if (a.equals("-enablesystemassertions") || a.equals("-esa") || a.equals("-disablesystemassertions") || a.equals("-dsa")) {
            return "systemassertions";
        }
        if (a.equals("-jre-restrict-search") || a.equals("-no-jre-restrict-search")) {
            return "-jre-restrict-search";
        }
        if (a.startsWith("-Xloggc:")) {
            return "-Xloggc";
        }
        if (a.startsWith("-Xloggc:")) {
            return "-Xloggc";
        }
        if (a.startsWith("-Xss")) {
            return "-Xss";
        }
        if (a.startsWith("-XX:+") || a.startsWith("-XX:-")) {
            return "-XX:" + a.substring("-XX:+".length());
        }
        if (a.contains("=")) {
            return a.substring(0, a.indexOf("="));
        }
        return a;
    }

    private List<String> buildJavaAgents() {
        List<String> agents0 = this.getListAttribute(ATTR_JAVA_AGENTS);
        if (agents0 == null) {
            return null;
        }
        ArrayList<String> agents = new ArrayList<String>(agents0.size());
        for (String agent : agents0) {
            String agentJar = Capsule.getBefore(agent, '=');
            String agentOptions = Capsule.getAfter(agent, '=');
            try {
                Path agentPath = this.getPath(agentJar);
                agents.add(agentPath + (agentOptions != null ? "=" + agentOptions : ""));
            }
            catch (IllegalStateException e) {
                if (this.appCache == null) {
                    throw new RuntimeException("Cannot run the embedded Java agent " + agentJar + " when the " + ATTR_EXTRACT + " attribute is set to false");
                }
                throw e;
            }
        }
        return agents;
    }

    private static JarFile getJarFile() {
        URL url = Capsule.class.getClassLoader().getResource(Capsule.class.getName().replace('.', '/') + ".class");
        if (!"jar".equals(url.getProtocol())) {
            throw new IllegalStateException("The Capsule class must be in a JAR file, but was loaded from: " + url);
        }
        String path = url.getPath();
        if (path == null || !path.startsWith("file:")) {
            throw new IllegalStateException("The Capsule class must be in a local JAR file, but was loaded from: " + url);
        }
        try {
            URI jarUri = new URI(path.substring(0, path.indexOf(33)));
            try {
                JarFile jar = new JarFile(new File(jarUri));
                return jar;
            }
            catch (IOException e) {
                throw new RuntimeException("Jar file containing the Capsule could not be opened: " + jarUri, e);
            }
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String getAppId(String[] args) {
        String appName = System.getProperty(PROP_APP_ID);
        if (appName == null) {
            appName = this.getAttribute(ATTR_APP_NAME);
        }
        if (appName == null && (appName = Capsule.getApplicationArtifactId(this.getAppArtifact(args))) != null) {
            return this.getAppArtifactLatestVersion(appName);
        }
        if (appName == null) {
            if (this.pom != null) {
                return this.getPomAppName();
            }
            appName = this.getAttribute(ATTR_APP_CLASS);
        }
        if (appName == null) {
            if (this.isEmptyCapsule()) {
                return null;
            }
            throw new RuntimeException("Capsule jar " + this.jar.getName() + " must either have the " + ATTR_APP_NAME + " manifest attribute, " + "the " + ATTR_APP_CLASS + " attribute, or contain a " + POM_FILE + " file.");
        }
        String version = this.hasAttribute(ATTR_APP_VERSION) ? this.getAttribute(ATTR_APP_VERSION) : this.getAttribute(ATTR_IMPLEMENTATION_VERSION);
        return appName + (version != null ? "_" + version : "");
    }

    private String getMainClass(List<Path> classPath) {
        try {
            String mainClass = this.getAttribute(ATTR_APP_CLASS);
            if (mainClass == null && this.hasAttribute(ATTR_APP_ARTIFACT)) {
                mainClass = Capsule.getMainClass(new JarFile(classPath.get(0).toAbsolutePath().toString()));
            }
            if (mainClass == null) {
                throw new RuntimeException("Jar " + classPath.get(0).toAbsolutePath() + " does not have a main class defined in the manifest.");
            }
            return mainClass;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Path> getDefaultCacheClassPath() {
        ArrayList<Path> cp = new ArrayList<Path>();
        cp.add(this.appCache);
        for (File f : this.appCache.toFile().listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
            cp.add(f.toPath());
        }
        return cp;
    }

    private Path getPath(String p) {
        if (Capsule.isDependency(p) && this.dependencyManager != null) {
            return Capsule.getDependencyPath(this.dependencyManager, p);
        }
        if (this.appCache == null) {
            throw new IllegalStateException((Capsule.isDependency(p) ? "Dependency manager not found. Cannot resolve" : "Capsule not extracted. Cannot obtain path") + " " + p);
        }
        if (Capsule.isDependency(p)) {
            Path f = this.appCache.resolve(this.dependencyToLocalJar(true, p));
            if (Files.isRegularFile(f, new LinkOption[0])) {
                return f;
            }
            f = this.appCache.resolve(this.dependencyToLocalJar(false, p));
            if (Files.isRegularFile(f, new LinkOption[0])) {
                return f;
            }
            throw new IllegalArgumentException("Dependency manager not found, and could not locate artifact " + p + " in capsule");
        }
        return Capsule.toAbsolutePath(this.appCache, p);
    }

    private String dependencyToLocalJar(boolean withGroupId, String p) {
        String[] coords = p.split(":");
        StringBuilder sb = new StringBuilder();
        if (withGroupId) {
            sb.append(coords[0]).append('-');
        }
        sb.append(coords[1]).append('-');
        sb.append(coords[2]);
        if (coords.length > 3) {
            sb.append('-').append(coords[3]);
        }
        sb.append(".jar");
        return sb.toString();
    }

    private List<Path> getPath(List<String> ps) {
        if (ps == null) {
            return null;
        }
        ArrayList<Path> res = new ArrayList<Path>(ps.size());
        for (String p : ps) {
            res.add(this.getPath(p));
        }
        return res;
    }

    private String toJarUrl(String relPath) {
        return "jar:file:" + this.getJarPath() + "!/" + relPath;
    }

    private static List<Path> toPath(List<String> ps) {
        if (ps == null) {
            return null;
        }
        ArrayList<Path> aps = new ArrayList<Path>(ps.size());
        for (String p : ps) {
            aps.add(Paths.get(p, new String[0]));
        }
        return aps;
    }

    private static List<Path> toAbsolutePath(Path root, List<String> ps) {
        if (ps == null) {
            return null;
        }
        ArrayList<Path> aps = new ArrayList<Path>(ps.size());
        for (String p : ps) {
            aps.add(Capsule.toAbsolutePath(root, p));
        }
        return aps;
    }

    private static Path toAbsolutePath(Path root, String p) {
        return root.resolve(Capsule.sanitize(p)).toAbsolutePath();
    }

    private String getAttribute(String attr) {
        Attributes atts;
        String value = null;
        if (this.mode != null) {
            atts = this.manifest.getAttributes(this.mode);
            if (atts == null) {
                throw new IllegalArgumentException("Mode " + this.mode + " not defined in manifest");
            }
            value = atts.getValue(attr);
        }
        if (value == null) {
            atts = this.manifest.getMainAttributes();
            value = atts.getValue(attr);
        }
        return value;
    }

    private boolean hasAttribute(String attr) {
        Attributes atts;
        Attributes.Name key = new Attributes.Name(attr);
        if (this.mode != null && (atts = this.manifest.getAttributes(this.mode)) != null && atts.containsKey(key)) {
            return true;
        }
        atts = this.manifest.getMainAttributes();
        return atts.containsKey(new Attributes.Name(attr));
    }

    private List<String> getListAttribute(String attr) {
        return this.split(this.getAttribute(attr), "\\s+");
    }

    private List<String> split(String str, String separator) {
        if (str == null) {
            return null;
        }
        return Arrays.asList(str.split(separator));
    }

    private Path getAppCacheDir() {
        Path appDir = cacheDir.resolve(APP_CACHE_NAME).resolve(this.appId);
        try {
            if (!Files.exists(appDir, new LinkOption[0])) {
                Files.createDirectory(appDir, new FileAttribute[0]);
            }
            return appDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Application cache directory " + appDir.toAbsolutePath() + " could not be created.");
        }
    }

    private static Path getCacheDir() {
        Path cache;
        String cacheDirEnv = System.getenv(ENV_CACHE_DIR);
        if (cacheDirEnv != null) {
            cache = Paths.get(cacheDirEnv, new String[0]);
        } else {
            String cacheNameEnv = System.getenv(ENV_CACHE_NAME);
            String cacheName = cacheNameEnv != null ? cacheNameEnv : CACHE_DEFAULT_NAME;
            cache = Capsule.getCacheHome().resolve((Capsule.isWindows() ? "" : ".") + cacheName);
        }
        try {
            if (!Files.exists(cache, new LinkOption[0])) {
                Files.createDirectory(cache, new FileAttribute[0]);
            }
            if (!Files.exists(cache.resolve(APP_CACHE_NAME), new LinkOption[0])) {
                Files.createDirectory(cache.resolve(APP_CACHE_NAME), new FileAttribute[0]);
            }
            if (!Files.exists(cache.resolve(DEPS_CACHE_NAME), new LinkOption[0])) {
                Files.createDirectory(cache.resolve(DEPS_CACHE_NAME), new FileAttribute[0]);
            }
            return cache;
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening cache directory " + cache.toAbsolutePath(), e);
        }
    }

    private static Path getCacheHome() {
        Path localData;
        Path userHome = Paths.get(System.getProperty(PROP_USER_HOME), new String[0]);
        if (!Capsule.isWindows()) {
            return userHome;
        }
        String localAppData = System.getenv("LOCALAPPDATA");
        if (localAppData != null) {
            localData = Paths.get(localAppData, new String[0]);
            if (!Files.isDirectory(localData, new LinkOption[0])) {
                throw new RuntimeException("%LOCALAPPDATA% set to nonexistent directory " + localData);
            }
        } else {
            localData = userHome.resolve(Paths.get("AppData", "Local"));
            if (!Files.isDirectory(localData, new LinkOption[0])) {
                localData = userHome.resolve(Paths.get("Local Settings", "Application Data"));
            }
            if (!Files.isDirectory(localData, new LinkOption[0])) {
                throw new RuntimeException("%LOCALAPPDATA% is undefined, and neither " + userHome.resolve(Paths.get("AppData", "Local")) + " nor " + userHome.resolve(Paths.get("Local Settings", "Application Data")) + " have been found");
            }
        }
        return localData;
    }

    private boolean needsAppCache() {
        if (this.isEmptyCapsule()) {
            return false;
        }
        if (this.hasRenamedNativeDependencies()) {
            return true;
        }
        if (this.hasAttribute(ATTR_APP_ARTIFACT)) {
            return false;
        }
        return this.shouldExtract();
    }

    private boolean shouldExtract() {
        String extract = this.getAttribute(ATTR_EXTRACT);
        return extract == null || Boolean.parseBoolean(extract);
    }

    private void resetAppCache() {
        try {
            Capsule.debug("Creating cache for " + this.jar.getName() + " in " + this.appCache.toAbsolutePath());
            Capsule.delete(this.appCache);
            Files.createDirectory(this.appCache, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while extracting jar " + this.jar.getName() + " to app cache directory " + this.appCache.toAbsolutePath(), e);
        }
    }

    private boolean isUpToDate() {
        if (Boolean.parseBoolean(System.getProperty(PROP_RESET, "false"))) {
            return false;
        }
        try {
            Path jarFile;
            FileTime jarTime;
            Path extractedFile = this.appCache.resolve(".extracted");
            if (!Files.exists(extractedFile, new LinkOption[0])) {
                return false;
            }
            FileTime extractedTime = Files.getLastModifiedTime(extractedFile, new LinkOption[0]);
            return extractedTime.compareTo(jarTime = Files.getLastModifiedTime(jarFile = Paths.get(this.jar.getName(), new String[0]), new LinkOption[0])) >= 0;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void extractCapsule() {
        try {
            Capsule.verbose("Extracting " + this.jar.getName() + " to app cache directory " + this.appCache.toAbsolutePath());
            Capsule.extractJar(this.jar, this.appCache);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while extracting jar " + this.jar.getName() + " to app cache directory " + this.appCache.toAbsolutePath(), e);
        }
    }

    private void markCache() {
        try {
            Files.createFile(this.appCache.resolve(".extracted"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isCapsule(Path path) {
        try {
            if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar")) {
                JarFile jar = new JarFile(path.toFile());
                return Capsule.isCapsule(jar);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isCapsule(JarFile jar) {
        return "Capsule".equals(Capsule.getMainClass(jar));
    }

    private static String getMainClass(JarFile jar) {
        try {
            Manifest manifest = jar.getManifest();
            if (manifest != null) {
                return manifest.getMainAttributes().getValue("Main-Class");
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void extractJar(JarFile jar, Path targetDir) throws IOException {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String dir;
            JarEntry file = entries.nextElement();
            if (file.isDirectory() || file.getName().equals(Capsule.class.getName().replace('.', '/') + ".class") || file.getName().startsWith(Capsule.class.getName().replace('.', '/') + "$") && file.getName().endsWith(".class") || file.getName().endsWith(".class") || file.getName().startsWith("capsule/") || (dir = Capsule.getDirectory(file.getName())) != null && dir.startsWith("META-INF")) continue;
            if (dir != null) {
                Files.createDirectories(targetDir.resolve(dir), new FileAttribute[0]);
            }
            Path targetFile = targetDir.resolve(file.getName());
            InputStream is = jar.getInputStream(file);
            Throwable throwable = null;
            try {
                Files.copy(is, targetFile, new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private static String getDirectory(String filename) {
        int index = filename.lastIndexOf(47);
        if (index < 0) {
            return null;
        }
        return filename.substring(0, index);
    }

    private String getJavaHome() {
        String jhome = System.getProperty(PROP_CAPSULE_JAVA_HOME);
        if (jhome == null && !this.isMatchingJavaVersion(System.getProperty(PROP_JAVA_VERSION))) {
            boolean jdk = this.hasAttribute(ATTR_JDK_REQUIRED) && Boolean.parseBoolean(this.getAttribute(ATTR_JDK_REQUIRED));
            Path javaHomePath = this.findJavaHome(jdk);
            if (javaHomePath == null) {
                throw new RuntimeException("Could not find Java installation for requested version " + this.getAttribute(ATTR_MIN_JAVA_VERSION) + " / " + this.getAttribute(ATTR_JAVA_VERSION) + "(JDK required: " + jdk + ")" + ". You can override the used Java version with the -D" + PROP_CAPSULE_JAVA_HOME + " flag.");
            }
            jhome = javaHomePath.toAbsolutePath().toString();
        }
        return jhome;
    }

    private boolean isMatchingJavaVersion(String javaVersion) {
        try {
            if (this.hasAttribute(ATTR_MIN_JAVA_VERSION) && Capsule.compareVersions(javaVersion, this.getAttribute(ATTR_MIN_JAVA_VERSION)) < 0) {
                return false;
            }
            return !this.hasAttribute(ATTR_JAVA_VERSION) || Capsule.compareVersions(Capsule.majorJavaVersion(javaVersion), this.getAttribute(ATTR_JAVA_VERSION)) <= 0;
        }
        catch (IllegalArgumentException ex) {
            Capsule.verbose("Error parsing Java version " + javaVersion);
            return false;
        }
    }

    private String getJavaProcessName(String javaHome) {
        if (javaHome == null) {
            javaHome = System.getProperty(PROP_JAVA_HOME);
        }
        String javaProcessName = javaHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "java" + (Capsule.isWindows() ? ".exe" : "");
        return javaProcessName;
    }

    protected static boolean isWindows() {
        return System.getProperty(PROP_OS_NAME).toLowerCase().startsWith("windows");
    }

    protected static boolean isMac() {
        return System.getProperty(PROP_OS_NAME).toLowerCase().startsWith("mac");
    }

    protected static boolean isLinux() {
        return System.getProperty(PROP_OS_NAME).toLowerCase().contains("nux");
    }

    private static boolean isDependency(String lib) {
        return lib.contains(":");
    }

    private static String sanitize(String path) {
        if (path.startsWith("/") || path.startsWith("../") || path.contains("/../")) {
            throw new IllegalArgumentException("Path " + path + " is not local");
        }
        return path;
    }

    private static String join(Collection<?> coll, String separator) {
        if (coll == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object e : coll) {
            if (e == null) continue;
            sb.append(e).append(separator);
        }
        sb.delete(sb.length() - separator.length(), sb.length());
        return sb.toString();
    }

    private static String getBefore(String s, char separator) {
        int i = s.indexOf(separator);
        if (i < 0) {
            return s;
        }
        return s.substring(0, i);
    }

    private static String getAfter(String s, char separator) {
        int i = s.indexOf(separator);
        if (i < 0) {
            return null;
        }
        return s.substring(i + 1);
    }

    private boolean hasPom() {
        return this.jar.getEntry(POM_FILE) != null;
    }

    private Object createPomReader() {
        try {
            return new PomReader(this.jar.getInputStream(this.jar.getEntry(POM_FILE)));
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Jar " + this.jar.getName() + " contains a pom.xml file, while the necessary dependency management classes are not found in the jar");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed reading pom", e);
        }
    }

    private List<String> getPomRepositories() {
        return ((PomReader)this.pom).getRepositories();
    }

    private List<String> getPomDependencies() {
        return ((PomReader)this.pom).getDependencies();
    }

    private String getPomAppName() {
        PomReader pr = (PomReader)this.pom;
        return pr.getGroupId() + "_" + pr.getArtifactId() + "_" + pr.getVersion();
    }

    private Object createDependencyManager(List<String> repositories) {
        try {
            Path depsCache = cacheDir.resolve(DEPS_CACHE_NAME);
            boolean reset = Boolean.parseBoolean(System.getProperty(PROP_RESET, "false"));
            String local = Capsule.expandCommandLinePath(System.getProperty(PROP_USE_LOCAL_REPO));
            Path localRepo = depsCache;
            if (local != null) {
                localRepo = !local.isEmpty() ? Paths.get(local, new String[0]) : DEFAULT_LOCAL_MAVEN;
            }
            Capsule.debug("Local repo: " + localRepo);
            boolean offline = "".equals(System.getProperty(PROP_OFFLINE)) || Boolean.parseBoolean(System.getProperty(PROP_OFFLINE));
            Capsule.debug("Offline: " + offline);
            DependencyManager dm = new DependencyManager(localRepo.toAbsolutePath(), repositories, reset, offline);
            return dm;
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Jar " + this.jar.getName() + " specifies dependencies, while the necessary dependency management classes are not found in the jar");
        }
    }

    private List<String> getRepositories() {
        ArrayList<String> repos = new ArrayList<String>();
        List<String> attrRepos = this.split(System.getenv(ENV_CAPSULE_REPOS), ":");
        if (attrRepos == null) {
            attrRepos = this.getListAttribute(ATTR_REPOSITORIES);
        }
        if (attrRepos != null) {
            repos.addAll(attrRepos);
        }
        if (this.pom != null) {
            for (String repo : Capsule.nullToEmpty(this.getPomRepositories())) {
                if (repos.contains(repo)) continue;
                repos.add(repo);
            }
        }
        return !repos.isEmpty() ? Collections.unmodifiableList(repos) : null;
    }

    protected List<String> getDependencies() {
        List<String> deps = this.getListAttribute(ATTR_DEPENDENCIES);
        if (deps == null && this.pom != null) {
            deps = this.getPomDependencies();
        }
        return deps != null ? Collections.unmodifiableList(deps) : null;
    }

    private void printDependencyTree(String root) {
        DependencyManager dm = (DependencyManager)this.dependencyManager;
        dm.printDependencyTree(root);
    }

    private void printDependencyTree(List<String> dependencies, String type) {
        if (dependencies == null) {
            return;
        }
        DependencyManager dm = (DependencyManager)this.dependencyManager;
        dm.printDependencyTree(dependencies, type);
    }

    private List<Path> resolveDependencies(List<String> dependencies, String type) {
        if (dependencies == null) {
            return null;
        }
        return ((DependencyManager)this.dependencyManager).resolveDependencies(dependencies, type);
    }

    private String getAppArtifactLatestVersion(String coords) {
        if (coords == null) {
            return null;
        }
        DependencyManager dm = (DependencyManager)this.dependencyManager;
        return dm.getLatestVersion(coords);
    }

    private List<Path> resolveAppArtifact(String coords) {
        if (coords == null) {
            return null;
        }
        DependencyManager dm = (DependencyManager)this.dependencyManager;
        return dm.resolveRoot(coords);
    }

    private static Path getDependencyPath(Object dependencyManager, String p) {
        if (dependencyManager == null) {
            throw new RuntimeException("No dependencies specified in the capsule. Cannot resolve dependency " + p);
        }
        DependencyManager dm = (DependencyManager)dependencyManager;
        List depsJars = dm.resolveDependency(p, "jar");
        if (depsJars == null || depsJars.isEmpty()) {
            throw new RuntimeException("Dependency " + p + " was not found.");
        }
        return ((Path)depsJars.iterator().next()).toAbsolutePath();
    }

    private static void delete(Path dir) throws IOException {
        Capsule.delete(dir.toFile());
    }

    private static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                Capsule.delete(c);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    private Path findJavaHome(boolean jdk) {
        Map<String, Path> homes = Capsule.getJavaHomes(jdk);
        if (homes == null) {
            return null;
        }
        Path best = null;
        String bestVersion = null;
        for (Map.Entry<String, Path> e : homes.entrySet()) {
            String v = e.getKey();
            if (!this.isMatchingJavaVersion(v) || bestVersion != null && Capsule.compareVersions(v, bestVersion) <= 0) continue;
            bestVersion = v;
            best = e.getValue();
        }
        return best;
    }

    private static Map<String, Path> getJavaHomes(boolean jdk) {
        for (Path dir = Paths.get(System.getProperty(PROP_JAVA_HOME), new String[0]).getParent(); dir != null; dir = dir.getParent()) {
            Map<String, Path> homes = Capsule.getJavaHomes(dir, jdk);
            if (homes == null) continue;
            return homes;
        }
        return null;
    }

    private static Map<String, Path> getJavaHomes(Path dir, boolean jdk) {
        File d = dir.toFile();
        if (!d.isDirectory()) {
            return null;
        }
        HashMap<String, Path> dirs = new HashMap<String, Path>();
        for (File f : d.listFiles()) {
            File home;
            String dirName;
            String ver;
            if (!f.isDirectory() || (ver = Capsule.isJavaDir(dirName = f.toPath().getFileName().toString())) == null || jdk && !Capsule.isJDK(dirName) || (home = Capsule.searchJavaHomeInDir(f)) == null) continue;
            dirs.put(Capsule.javaVersion(ver), home.toPath());
        }
        return !dirs.isEmpty() ? dirs : null;
    }

    private static String isJavaDir(String fileName) {
        if ((fileName = fileName.toLowerCase()).startsWith("jdk") || fileName.startsWith("jre") || fileName.endsWith(".jdk") || fileName.endsWith(".jre")) {
            if (fileName.startsWith("jdk") || fileName.startsWith("jre")) {
                fileName = fileName.substring(3);
            }
            if (fileName.endsWith(".jdk") || fileName.endsWith(".jre")) {
                fileName = fileName.substring(0, fileName.length() - 4);
            }
            return Capsule.javaVersion(fileName);
        }
        return null;
    }

    private static boolean isJDK(String filename) {
        return filename.toLowerCase().contains("jdk");
    }

    private static String javaVersion(String ver) {
        try {
            String[] comps = ver.split("\\.");
            if (Integer.parseInt(comps[0]) > 1) {
                if (comps.length == 1) {
                    return "1." + ver + ".0";
                }
                return "1." + ver;
            }
            return ver;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static File searchJavaHomeInDir(File dir) {
        if (!dir.isDirectory()) {
            return null;
        }
        for (File f : dir.listFiles()) {
            if (Capsule.isJavaHome(f)) {
                return f;
            }
            File home = Capsule.searchJavaHomeInDir(f);
            if (home == null) continue;
            return home;
        }
        return null;
    }

    private static boolean isJavaHome(File dir) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                if (!f.isDirectory() || !f.toPath().getFileName().toString().equals("bin")) continue;
                for (File f0 : f.listFiles()) {
                    String fname;
                    if (!f0.isFile() || !(fname = f0.toPath().getFileName().toString().toLowerCase()).equals("java") && !fname.equals("java.exe")) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private static String majorJavaVersion(String v) {
        String[] vs = v.split("\\.");
        if (vs.length == 1) {
            return "1." + v;
        }
        return vs[0] + "." + vs[1];
    }

    static int compareVersions(String a, String b) {
        return Capsule.compareVersions(Capsule.parseJavaVersion(a), Capsule.parseJavaVersion(b));
    }

    private static int compareVersions(int[] a, int[] b) {
        for (int i = 0; i < 5; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] - b[i];
        }
        return 0;
    }

    static int[] parseJavaVersion(String v) {
        Matcher m = PAT_JAVA_VERSION.matcher(v);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse version: " + v);
        }
        int[] ver = new int[5];
        ver[0] = Capsule.toInt(m.group("major"));
        ver[1] = Capsule.toInt(m.group("minor"));
        ver[2] = Capsule.toInt(m.group("patch"));
        ver[3] = Capsule.toInt(m.group("update"));
        String pre = m.group("pre");
        if (pre != null) {
            if (pre.startsWith("rc")) {
                ver[4] = -1;
            } else if (pre.startsWith("beta")) {
                ver[4] = -2;
            } else if (pre.startsWith("ea")) {
                ver[4] = -3;
            }
        }
        return ver;
    }

    private static int toInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private static <T> List<T> nullToEmpty(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private static <T> Collection<T> nullToEmpty(Collection<T> coll) {
        if (coll == null) {
            return Collections.emptyList();
        }
        return coll;
    }

    private List<String> expand(List<String> strs) {
        if (strs == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(strs.size());
        for (String s : strs) {
            res.add(this.expand(s));
        }
        return res;
    }

    private String expand(String str) {
        if (this.appCache != null) {
            str = str.replaceAll("\\$CAPSULE_DIR", this.appCache.toAbsolutePath().toString());
        } else if (str.contains("$CAPSULE_DIR")) {
            throw new IllegalStateException("The $CAPSULE_DIR variable cannot be expanded when the Extract-Capsule attribute is set to false");
        }
        str = Capsule.expandCommandLinePath(str);
        str = str.replaceAll("\\$CAPSULE_JAR", this.getJarPath());
        str = str.replaceAll("\\$JAVA_HOME", this.javaHome != null ? this.javaHome : System.getProperty(PROP_JAVA_HOME));
        str = str.replace('/', FILE_SEPARATOR.charAt(0));
        return str;
    }

    private static String expandCommandLinePath(String str) {
        if (str == null) {
            return null;
        }
        return str.startsWith("~/") ? str.replace("~", System.getProperty(PROP_USER_HOME)) : str;
    }

    private static String getApplicationArtifactId(String coords) {
        if (coords == null) {
            return null;
        }
        String[] cs = coords.split(":");
        if (cs.length < 2) {
            throw new IllegalArgumentException("Illegal main artifact coordinates: " + coords);
        }
        String id = cs[0] + "_" + cs[1];
        if (cs.length > 2) {
            id = id + "_" + cs[2];
        }
        return id;
    }

    private static void runCapsule(Path path, String[] args) {
        try {
            URLClassLoader cl = new URLClassLoader(new URL[]{path.toUri().toURL()}, null);
            Class<?> cls = cl.loadClass("Capsule");
            Method main = cls.getMethod("main", String[].class);
            main.invoke(cls, new Object[]{args});
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(path + " does not appear to be a valid capsule.", e);
        }
        catch (IllegalAccessException | MalformedURLException e) {
            throw new AssertionError();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    private static boolean anyPropertyDefined(String ... props) {
        for (String prop : props) {
            if (System.getProperty(prop) == null) continue;
            return true;
        }
        return false;
    }

    private static void println(String str) {
        System.err.println("CAPSULE: " + str);
    }

    private static void verbose(String str) {
        if (verbose) {
            System.err.println("CAPSULE: " + str);
        }
    }

    private static void debug(String str) {
        if (debug) {
            System.err.println("CAPSULE: " + str);
        }
    }
}

