/*
 * (C) Copyright 2015 Nuxeo SA (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Benoit Delbosc
 */
package db;


import java.util.ArrayList;
import java.util.List;

public class Node {

    public final Document doc;

    public final List<Node> children = new ArrayList<>();

    public Node(Document doc) {
        this.doc = doc;
    }

    public void addChildren(Node node) {
        children.add(node);
    }

    public boolean isRoot() {
        return doc == null;
    }
}
