/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.nuxeo.targetplatforms.api.TargetInfo;

public class TargetInfoImpl
implements TargetInfo {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected String version;
    protected String refVersion;
    protected String label;
    protected String description;
    protected String status;
    protected boolean enabled = true;
    protected boolean restricted = false;
    protected boolean fastTrack = false;
    protected boolean trial = false;
    protected boolean isDefault = false;
    protected Date releaseDate;
    protected Date endOfAvailability;
    protected String downloadLink;
    protected boolean deprecated = false;
    protected boolean overridden = false;
    protected List<String> types;

    protected TargetInfoImpl() {
    }

    public TargetInfoImpl(String id) {
        this.id = id;
    }

    public TargetInfoImpl(String id, String name, String version, String refVersion, String label) {
        this(id);
        this.name = name;
        this.version = version;
        this.refVersion = refVersion;
        this.label = label;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getRefVersion() {
        if (this.refVersion == null) {
            return this.version;
        }
        return this.refVersion;
    }

    public void setRefVersion(String refVersion) {
        this.refVersion = refVersion;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    @Override
    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    @Override
    public Date getEndOfAvailability() {
        return this.endOfAvailability;
    }

    public void setEndOfAvailability(Date endOfAvailability) {
        this.endOfAvailability = endOfAvailability;
    }

    @Override
    public String getDownloadLink() {
        return this.downloadLink;
    }

    public void setDownloadLink(String downloadLink) {
        this.downloadLink = downloadLink;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public boolean isTrial() {
        return this.trial;
    }

    public void setTrial(boolean trial) {
        this.trial = trial;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public boolean isFastTrack() {
        return this.fastTrack;
    }

    public void setFastTrack(boolean fastTrack) {
        this.fastTrack = fastTrack;
    }

    @Override
    public boolean isOverridden() {
        return this.overridden;
    }

    public void setOverridden(boolean overridden) {
        this.overridden = overridden;
    }

    @Override
    public List<String> getTypes() {
        if (this.types == null) {
            return Collections.emptyList();
        }
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types == null ? null : new ArrayList<String>(types);
    }

    @Override
    public boolean matchesType(String type) {
        if (this.types == null) {
            return false;
        }
        return this.types.contains(type);
    }

    protected String getSimpleName() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getSimpleName());
        buf.append(" {");
        buf.append(" id=");
        buf.append(this.id);
        buf.append(", name=");
        buf.append(this.name);
        buf.append(", version=");
        buf.append(this.version);
        buf.append(", refVersion=");
        buf.append(this.refVersion);
        buf.append(", label=");
        buf.append(this.label);
        buf.append('}');
        return buf.toString();
    }
}

