/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.targetplatforms.api.TargetPackage;
import org.nuxeo.targetplatforms.api.TargetPlatform;
import org.nuxeo.targetplatforms.api.TargetPlatformInstance;
import org.nuxeo.targetplatforms.api.impl.TargetImpl;

public class TargetPlatformInstanceImpl
extends TargetImpl
implements TargetPlatformInstance {
    private static final long serialVersionUID = 1L;
    protected TargetPlatform parent;
    protected Map<String, TargetPackage> enabledPackages;

    protected TargetPlatformInstanceImpl() {
    }

    public TargetPlatformInstanceImpl(String id) {
        super(id);
    }

    public TargetPlatformInstanceImpl(String id, String name, String version, String refVersion, String label) {
        super(id, name, version, refVersion, label);
    }

    @Override
    public List<String> getEnabledPackagesIds() {
        if (this.enabledPackages == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.enabledPackages.keySet());
    }

    @Override
    public Map<String, TargetPackage> getEnabledPackages() {
        if (this.enabledPackages == null) {
            return Collections.emptyMap();
        }
        return this.enabledPackages;
    }

    public void addEnabledPackage(TargetPackage pack) {
        if (pack == null) {
            return;
        }
        if (this.enabledPackages == null) {
            this.enabledPackages = new LinkedHashMap<String, TargetPackage>();
        }
        this.enabledPackages.put(pack.getId(), pack);
    }

    public void setEnabledPackages(Map<String, TargetPackage> packages) {
        if (this.enabledPackages == null) {
            this.enabledPackages = new LinkedHashMap<String, TargetPackage>();
        } else {
            this.enabledPackages.clear();
        }
        if (packages != null) {
            this.enabledPackages.putAll(packages);
        }
    }

    @Override
    public boolean hasEnabledPackageWithName(String packageName) {
        if (packageName == null || this.enabledPackages == null) {
            return false;
        }
        for (TargetPackage pkg : this.enabledPackages.values()) {
            if (pkg == null || !packageName.equals(pkg.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public TargetPlatform getParent() {
        return this.parent;
    }

    public void setParent(TargetPlatform parent) {
        this.parent = parent;
    }
}

