/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.api.impl;

import org.nuxeo.targetplatforms.api.Target;
import org.nuxeo.targetplatforms.api.impl.TargetInfoImpl;

public class TargetImpl
extends TargetInfoImpl
implements Target {
    private static final long serialVersionUID = 1L;

    protected TargetImpl() {
    }

    public TargetImpl(String id) {
        super(id);
    }

    public TargetImpl(String id, String name, String version, String refVersion, String label) {
        super(id, name, version, refVersion, label);
    }

    @Override
    public boolean isAfterVersion(String version) {
        if (version == null || version.trim().length() == 0 || this.getRefVersion().equals(version)) {
            return true;
        }
        String[] components1 = this.getRefVersion().split("\\.");
        String[] components2 = version.split("\\.");
        int length = Math.min(components1.length, components2.length);
        for (int i = 0; i < length; ++i) {
            int result = Integer.compare(Integer.valueOf(components1[i]), Integer.valueOf(components2[i]));
            if (result == 0) continue;
            return result > 0;
        }
        return components1.length > components2.length;
    }

    @Override
    public boolean isStrictlyBeforeVersion(String version) {
        if (version == null || version.trim().length() == 0) {
            return true;
        }
        String[] components1 = this.getRefVersion().split("\\.");
        String[] components2 = version.split("\\.");
        int length = Math.min(components1.length, components2.length);
        for (int i = 0; i < length; ++i) {
            int result = Integer.compare(Integer.valueOf(components1[i]), Integer.valueOf(components2[i]));
            if (result == 0) continue;
            return result < 0;
        }
        return components1.length < components2.length;
    }

    @Override
    public boolean isVersion(String version) {
        if (version == null || version.trim().length() == 0) {
            return false;
        }
        return version.compareTo(this.getRefVersion()) == 0;
    }

    @Override
    public boolean isStrictlyBeforeVersion(Target version) {
        return this.isStrictlyBeforeVersion(version.getRefVersion());
    }

    @Override
    public boolean isAfterVersion(Target version) {
        return this.isAfterVersion(version.getRefVersion());
    }

    @Override
    public boolean isVersion(Target version) {
        return this.isVersion(this.getRefVersion());
    }
}

