/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.jaxrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.targetplatforms.api.TargetPackage;
import org.nuxeo.targetplatforms.api.TargetPackageInfo;
import org.nuxeo.targetplatforms.api.TargetPlatform;
import org.nuxeo.targetplatforms.api.TargetPlatformFilter;
import org.nuxeo.targetplatforms.api.TargetPlatformInfo;
import org.nuxeo.targetplatforms.api.TargetPlatformInstance;
import org.nuxeo.targetplatforms.api.impl.TargetPlatformFilterImpl;
import org.nuxeo.targetplatforms.api.service.TargetPlatformService;
import org.nuxeo.targetplatforms.jaxrs.TargetPlatforms;
import org.nuxeo.targetplatforms.jaxrs.TargetPlatformsInfo;

@Path(value="target-platforms")
public class RootResource {
    @GET
    public Object doGet(@QueryParam(value="filterDisabled") boolean filterDisabled, @QueryParam(value="filterRestricted") boolean filterRestricted, @QueryParam(value="filterDeprecated") boolean filterDeprecated, @QueryParam(value="filterDefault") Boolean filterDefault, @QueryParam(value="filterType") String filterType) throws Exception {
        return this.getPlatforms(filterDisabled, filterRestricted, filterDeprecated, filterDefault, filterType);
    }

    @GET
    @Path(value="platform/{id}")
    public Object getPlatform(@PathParam(value="id") String id) throws Exception {
        TargetPlatformService tps = (TargetPlatformService)Framework.getService(TargetPlatformService.class);
        TargetPlatform res = tps.getTargetPlatform(id);
        if (res != null) {
            return res;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="platforms")
    public Object getPlatforms(@QueryParam(value="filterDisabled") boolean filterDisabled, @QueryParam(value="filterRestricted") boolean filterRestricted, @QueryParam(value="filterDeprecated") boolean filterDeprecated, @QueryParam(value="filterDefault") Boolean filterDefault, @QueryParam(value="filterType") String filterType) throws Exception {
        boolean doFilterDefault;
        TargetPlatformService tps = (TargetPlatformService)Framework.getService(TargetPlatformService.class);
        List res = tps.getAvailableTargetPlatforms((TargetPlatformFilter)new TargetPlatformFilterImpl(filterDisabled, filterRestricted, filterDeprecated, doFilterDefault = Boolean.TRUE.equals(filterDefault), filterType));
        if (res == null) {
            return new TargetPlatforms();
        }
        return new TargetPlatforms(res);
    }

    @GET
    @Path(value="platform-info/{id}")
    public Object getPlatformInfo(@PathParam(value="id") String id) throws Exception {
        TargetPlatformService tps = (TargetPlatformService)Framework.getService(TargetPlatformService.class);
        TargetPlatformInfo res = tps.getTargetPlatformInfo(id);
        if (res != null) {
            return res;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="platforms-info")
    public Object getPlatformInfos(@QueryParam(value="filterDisabled") boolean filterDisabled, @QueryParam(value="filterRestricted") boolean filterRestricted, @QueryParam(value="filterDeprecated") boolean filterDeprecated, @QueryParam(value="filterDefault") Boolean filterDefault, @QueryParam(value="filterType") String filterType) throws Exception {
        boolean doFilterDefault;
        TargetPlatformService tps = (TargetPlatformService)Framework.getService(TargetPlatformService.class);
        List res = tps.getAvailableTargetPlatformsInfo((TargetPlatformFilter)new TargetPlatformFilterImpl(filterDisabled, filterRestricted, filterDeprecated, doFilterDefault = Boolean.TRUE.equals(filterDefault), filterType));
        if (res == null) {
            return new TargetPlatformsInfo();
        }
        return new TargetPlatformsInfo(res);
    }

    @GET
    @Path(value="platform-instance/{id}")
    public Object getPlatformInstance(@PathParam(value="id") String id, @QueryParam(value="packages") String packages) throws Exception {
        TargetPlatformInstance res;
        TargetPlatformService tps = (TargetPlatformService)Framework.getService(TargetPlatformService.class);
        ArrayList<String> plist = new ArrayList<String>();
        if (packages != null) {
            plist.addAll(Arrays.asList(packages.split(",")));
        }
        if ((res = tps.getTargetPlatformInstance(id, plist)) != null) {
            return res;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="package/{id}")
    public Object getPackage(@PathParam(value="id") String id) throws Exception {
        TargetPlatformService tps = (TargetPlatformService)Framework.getService(TargetPlatformService.class);
        TargetPackage res = tps.getTargetPackage(id);
        if (res != null) {
            return res;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="package-info/{id}")
    public Object getPackageInfo(@PathParam(value="id") String id) throws Exception {
        TargetPlatformService tps = (TargetPlatformService)Framework.getService(TargetPlatformService.class);
        TargetPackageInfo res = tps.getTargetPackageInfo(id);
        if (res != null) {
            return res;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

