/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.jdbc.spy;

import com.impossibl.jdbc.spy.ConnectionListener;
import com.impossibl.jdbc.spy.ConnectionTracer;
import com.impossibl.jdbc.spy.PooledConnectionListener;
import com.impossibl.jdbc.spy.Trace;
import com.impossibl.jdbc.spy.TraceOutput;
import java.sql.Connection;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;

public class PooledConnectionTracer
implements PooledConnectionListener {
    TraceOutput out;

    public PooledConnectionTracer(TraceOutput out) {
        this.out = out;
    }

    public void trace(Trace trace) {
        this.out.trace(trace);
    }

    @Override
    public void getConnection(Connection result) {
        this.trace(new Trace.Builder("PooledConnection", "getConnection").returned(result).build());
    }

    @Override
    public void getConnection(Throwable cause) {
        this.trace(new Trace.Builder("PooledConnection", "getConnection").threw(cause).build());
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.trace(new Trace.Builder("PooledConnection", "removeConnectionEventListener").withParameter("listener", listener).returned().build());
    }

    @Override
    public void removeConnectionEventListener(Throwable cause, ConnectionEventListener listener) {
        this.trace(new Trace.Builder("PooledConnection", "removeConnectionEventListener").withParameter("listener", listener).threw(cause).build());
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.trace(new Trace.Builder("PooledConnection", "addStatementEventListener").withParameter("listener", listener).returned().build());
    }

    @Override
    public void addStatementEventListener(Throwable cause, StatementEventListener listener) {
        this.trace(new Trace.Builder("PooledConnection", "addStatementEventListener").withParameter("listener", listener).threw(cause).build());
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.trace(new Trace.Builder("PooledConnection", "removeStatementEventListener").withParameter("listener", listener).returned().build());
    }

    @Override
    public void removeStatementEventListener(Throwable cause, StatementEventListener listener) {
        this.trace(new Trace.Builder("PooledConnection", "removeStatementEventListener").withParameter("listener", listener).threw(cause).build());
    }

    @Override
    public void close() {
        this.trace(new Trace.Builder("PooledConnection", "close").returned().build());
    }

    @Override
    public void close(Throwable cause) {
        this.trace(new Trace.Builder("PooledConnection", "close").threw(cause).build());
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.trace(new Trace.Builder("PooledConnection", "addConnectionEventListener").withParameter("listener", listener).returned().build());
    }

    @Override
    public void addConnectionEventListener(Throwable cause, ConnectionEventListener listener) {
        this.trace(new Trace.Builder("PooledConnection", "addConnectionEventListener").withParameter("listener", listener).threw(cause).build());
    }

    @Override
    public ConnectionListener newConnectionListener() {
        return new ConnectionTracer(this.out);
    }
}

